package webFramework.jspSelection;

import webFramework.util.*;
import webFramework.deviceManagement.*;
 
import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * JSPSelectionRuleParser.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
    
class JSPSelectionRuleParser extends DefaultReaderStackElement {

	private DeviceSpecManager dsm;
	private JSPSelectionRuleManager jsprm;
	private JSPMapping jspMapping = new JSPMapping();

	public JSPSelectionRuleParser(JSPSelectionRuleManager jsprm,
				DeviceSpecManager dsm) {

	    this.jsprm = jsprm;
	    this.dsm = dsm;
	}

	public void startElement(ReaderStack stack, java.lang.String uri,
				String localName, String rawName,
				Attributes attributes) throws SAXException {

	    if (localName.equals("device")) {
		stack.push(new DeviceOrCategoryParser(dsm, jspMapping));
	    } else
		stack.push(new PropertyParser(jspMapping, localName));
	}

	public void endElement(ReaderStack stack, String uri, String localName,
				String rawName) throws SAXException {

	    if (localName.equals("jsp-selection-rule")) {
		jsprm.addMapping(jspMapping);
		stack.pop();
	    }
	}

}

