package webFramework.jspSelection;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.IOException;
import java.util.*;

import webFramework.deviceManagement.*;

/**
 * RuleBasedJSPSelector.
 *   Selects which variant of a JSP page to use - based on the accept header
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class RuleBasedJSPSelector {

    private HttpServletRequest request;
    private ServletContext context;

    private static final boolean debug = false;

    public RuleBasedJSPSelector(ServletContext context,
			HttpServletRequest request) {

	this.context = context;
	this.request = request;
    }

    /**
     * Looks at the accept header to figure out what
     * content type is requested
     * 
     * @param jsp
     * @return 
     */
    public String selectJSP(String jsp) throws IOException {
	Device device = DeviceSpecManager.getInstance(context).findDevice(request);
	JSPMapping jspMapping = JSPSelectionRuleManager.getInstance(context).findJSPMapping(jsp, device);

        String directory = jspMapping.getDirectory();
	
	if (debug)
	  System.out.println("jsp = " + jsp);

	String fullJspName = "/" + directory + "/" + jsp;
	
	// Look at this too
	// String agent = request.getHeader("User-Agent");
	
	if (debug)
	  System.out.println("FullJSPName = " +  fullJspName);

	return fullJspName;
    }
}
