package webFramework.util;

import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * ConfigFileReader.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ConfigFileReader extends DefaultHandler {

    private ReaderStack stack = new ReaderStack();
    private InputStream is;

    public ConfigFileReader(InputStream is, ReaderStackElement stackElement) {
	this.is = is;
	stack.push(stackElement);
    }

    public void read() throws Exception {
	XMLReader parser = (XMLReader)Class.forName
		("weblogic.apache.xerces.parsers.SAXParser").newInstance();

	parser.setContentHandler(this);
	parser.setErrorHandler(this);
	parser.parse(new InputSource(is));
    }

    public void characters(char[] ch,
                       int start,
                       int length)
                throws SAXException {
	tos().characters(stack, ch, start, length);
    }

    public void startElement(java.lang.String uri,
                         String localName,
                         String rawName,
                         Attributes attributes)
                  throws SAXException {
	tos().startElement(stack, uri, localName, rawName, attributes);
    }

    public void endElement(String uri,
                       String localName,
                       String rawName)
                throws SAXException {
	tos().endElement(stack, uri, localName, rawName);
    }

    private ReaderStackElement tos() {
	return stack.tos();
    }
    
}
