package webFramework.util;

import java.io.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.beans.*;
import java.lang.reflect.*;

/**
 * PropertyParser.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class PropertyParser extends DefaultReaderStackElement {

	Object o;
	String name;

	public PropertyParser(Object o, String name) {
	    this.o = o;
	    this.name = name;
	}

	public void characters(ReaderStack stack, char[] ch, int start, int length) throws SAXException {
	    // sets the value of the specified property
	    try {
	    String value = new String(ch, start, length);
	    PropertyDescriptor[] pds = Introspector.getBeanInfo(o.getClass()).getPropertyDescriptors();
	    boolean done = false;
	    for (int i = 0 ; i < pds.length ; i++) {
		    PropertyDescriptor pd = pds[i];
		    if (pd.getName().equals(name) && pd.getWriteMethod() != null) {
			    Method m = pd.getWriteMethod();
			    m.invoke(o, new Object[]{convert(pd.getPropertyType(), value)});
			    done = true;
			    break;
		    }
	    }
	    //System.out.println("set property: " + name + ", " + done);
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	
	Object convert(Class type, String value) throws Exception {
	    if (type == Class.class)
		return Class.forName(value);
	    else if (type == String.class)
		return value;
	    else if (type == int.class || type == Integer.class)
		return new Integer(Integer.parseInt(value));
	    else if (type == boolean.class || type == Boolean.class)
		return new Boolean(value.equals("true"));
	    else
		return value;
	}

	public void endElement(ReaderStack stack, String uri, String localName, String rawName) throws SAXException {
	    stack.pop();
	}
    }
