package webFramework.util;

import java.util.*;

/**
 * XMLUtil.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class XMLUtil {
    public static String escape(String s) {
	String delim = "&<>"; 
	String[] escaped = new String[]{"&amp;", "&lt;", "&gt;"};

	StringTokenizer st = new StringTokenizer(s, delim, true);
	String result = "";
	while (st.hasMoreTokens()) {
	    String tok = st.nextToken();
	    int i = delim.indexOf(tok);
	    if (i == -1) {
		result += tok;
	    } else {
		result += escaped[i];
	    }
	}
	return result;
    }
}
