package examples.wireless.helloWorld;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.IOException;
import java.util.*;

import webFramework.jspSelection.*;

/**
 * An example servlet for the Controller-Servlet/JSP presenter pattern
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class HelloWirelessWorldServlet extends HttpServlet {

    private static final boolean debug = false;
        
    public void service(HttpServletRequest request,
			HttpServletResponse response)
        throws IOException, ServletException {

           forwardToJSP(request, response, "helloWorld.jsp");
        }
  /**
   *  Called from the service() method of this application.
   *  Forwards the incoming request to the correct directory (html, wml, 
   *  hdml, etc.) where this JSP resides, for the mobile device.
   *
   * @param request           HttpServletRequest
   * @param response          HttpServletResponse
   * @param jsp		      String 
   */

    protected void forwardToJSP(HttpServletRequest request,
				HttpServletResponse response, String jsp) 
     throws ServletException, IOException {

        // Simple debugging information about the incoming header.
	if (debug) {
	   Enumeration e = request.getHeaderNames();
	   while (e.hasMoreElements()) {
	       String name = (String)e.nextElement();
	       String value = request.getHeader(name);
	       System.out.println("Name= " + name + ", value= " + value);
	   }
	}

	 //In a real application the Selector might be specified
	 //by an InitParam

	 RuleBasedJSPSelector selector = new RuleBasedJSPSelector
					(getServletContext(), request);
         /*
          * Uses the framework to select the correct directory for the
          * jsp based on the incoming device.  It then uses this to send
          * back to the mobile device.
          */
	 String fullJspName = selector.selectJSP(jsp);
	 RequestDispatcher rd = getServletContext().getRequestDispatcher
				(fullJspName);
	 rd.forward(request, response);    
    }        
} 
