package stockDemo.ui.actions;

/**
 * Sample Stock Application that accepts user input of a stock, goes out
 * to the web (using data from http://quote.nasdaq.com) and returns the
 * price back to the user.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

import java.io.*;
import java.net.*;
import java.util.*;

import stockDemo.ui.session.*;
import webFramework.actions.*;

import org.w3c.dom.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;

public class StockAlertAction extends BaseAction{

        private ApplicationSession appSession;

        private String stock = new String();

        public StockAlertAction(ApplicationSession appSession) {
                this.appSession = appSession;
        }

        public void setStock(String stock) {
                this.stock = stock;
        }

	public ActionResult performAction() {

		if (stock == null) {
        		ActionResult ar = new ActionResult("displayPrice.jsp");
			ar.setMessage("Invalid Symbol, try again!");
       			return ar;
		}

		// Get the info we need based on stock to use later
		String price = StockInfo.getQuote(stock);
        	StringTokenizer st = new StringTokenizer(price);

		ActionResult ar = new ActionResult("displayPrice.jsp");
		ar.setMessage("Price: " +price);
		return ar;

        }

} //of Class

class StockInfo extends DefaultHandler{

  static String charactersFound, price = null;
  private static final boolean debug = false;

	public static String getQuote(String symbolName) {

          boolean parseStatus = true;

	    // make sure everything is cleared
	    charactersFound = null;
	    price = null;

	    StockInfo stockInfo = new StockInfo();
            try {
		// Create a SAXParserFactory and configure it
		SAXParserFactory spf = SAXParserFactory.newInstance();
		spf.setValidating(true);

		// Create a SAXParser
		SAXParser saxParser = spf.newSAXParser();

      		// Get the encapsulated SAX XMLReader
		XMLReader xmlReader;

		try {
			xmlReader = XMLReaderFactory.createXMLReader();
		} catch (SAXException ex) {
			xmlReader = XMLReaderFactory.createXMLReader(
				"weblogic.apache.xerces.parsers.SAXParser");
		}

        	// Set the ContentHandler of the XMLReader
		xmlReader.setContentHandler(stockInfo);

      	  	// Set an ErrorHandler before parsing
     	  	xmlReader.setErrorHandler(stockInfo);

		URL u = new URL("http://quotes.nasdaq.com/quote.dll?page=xml&;mode=stock&symbol=" + symbolName); 

		InputStream raw = u.openStream();
		InputStreamReader reader = new InputStreamReader(raw);
		InputSource inputsource = new InputSource(reader);

                xmlReader.parse(inputsource);

		if (debug) {
			if (parseStatus)
			  System.out.println("Parse was satisfactory.");	
			else
			  System.out.println("Errors during parse");	
		}

		} catch (SAXParseException err) {
			if (debug) {
    			  System.out.println ("Parse error, line "+err.getLineNumber()+", "+err.getSystemId());
	    		  System.out.println("   " + err.getMessage ());
 			}
			parseStatus = false;	

		}catch(IOException ioe){
			if (debug)
			  System.out.println("IOException:"+ioe.getMessage());
		}catch(SAXException saxe) {
			if (debug) {
			  System.out.println ("** SAXException **");
    			  Exception	e = saxe;
	    		  if (saxe.getException () != null)
			 	e = saxe.getException();
		    		e.printStackTrace();
				System.out.println("SAXException: " + e.getMessage());
			}
			parseStatus = false;

		}catch(Throwable t){
	    		t.printStackTrace();
			System.out.println(t.getMessage());
			parseStatus = false;	
		}

		if (price != null)
			return price;
		else
			return "Not available";


	} // of getQuote

	/** setDocumentLocator is called by the SAXParser to set 
        *  the locator for all SAX document events.
	*/ 
	public void setDocumentLocator(Locator locator){
	}

	/** startDocument is called by the SAXParser when it 
	*   hits the beginning of a XML document.
	*/
	public void startDocument() throws SAXException{
	}

	/** endDocument is called by the SAXParser when it 
	*   encounters the end of a XML document.
	*/
	public void endDocument() throws SAXException{
	}

	/** startElement is called by the SAXParser when it 
	*   encounters the beginning of a XML document element.
	*/
	public void startElement(String namespaceURI,String name,String qName, Attributes atts) throws SAXException{
	}

	/** endElement is called by the SAXParser when it 
	*   encounters the end of a XML document element.
	*/
	public void endElement(String uri,String name,String qname)throws SAXException {
		if (name.equalsIgnoreCase("last-sale-price")) {
		   price = charactersFound;

		   if (debug)
		     System.out.println("Price is:"+price);
  		}
	}

	/** characters is called by the SAXParser when it 
	*   encounters character data in a XML document.
	*/
	public void characters(char[] ch, int start, int length) throws SAXException{
		charactersFound = new String(ch,start,length);
	}

} // of StockInfo class

