package stockDemo.ui.servlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.beans.*;
import java.lang.reflect.*;
import java.util.*;

import stockDemo.ui.session.*;
import webFramework.actions.*;
import webFramework.jspSelection.*;

/**
 * The application's sole servlet class. 
 * Executes the action specified by the initParameter and forwards
 * to the specified JSP.
 *
 * Basically this will end up calling the frameWork in 
 * frameWork.webFramework.actions to execute the selected "action" 
 * which ends up calling the execute() that is implemented in 
 * stockDemo.ui.actions which sends back the resulting jsp (stockAlert.jsp).
 * This JSP then calls StockAlertAction.java which does the actual work of
 * getting the stock price and returning it back to the displayPrice.jsp
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ControllerServlet extends HttpServlet {

  private static final boolean debug = false;

	protected void service(HttpServletRequest request,
			HttpServletResponse response) throws IOException,
							ServletException {

	        // uses the framework to manage the session.
		ApplicationSessionManager asm = 
			new ApplicationSessionManager(request, response);
		ApplicationSession appSession = asm.getSession();

	        // calls makeAction in this servlet 
		Action action = makeAction(appSession);

	        // calls initializeAction in this servlet to help figure out
                // what "action".java file should be used in:
                // stockDemo.ui.actions
		initializeAction(action, request);

	        // calls the frameWork to execute the selected "action" 
		ActionResult result = action.execute();

                // uses the above information to forward the correct jsp
                // back to the mobile device.
		forwardToJSP(appSession, request, response, result);
	}

	private Action makeAction(ApplicationSession appSession) 
				throws IOException, ServletException {

	        // specifies what "Action" should take place.
		String actionClass = getInitParameter("actionClass");
		try {
  		  Class c = Class.forName(actionClass);
		  Constructor cons = c.getConstructor
				(new Class[]{appSession.getClass()});
		  return (Action)cons.newInstance(new Object[]{appSession});
		} catch (Exception e) {
		  e.printStackTrace();
		  return null;
		}
	}

	/** 
	 * Use introspection to initialize the Action's properties 
         * with request parameters 
	 *
	 * @param action		Action
	 * @param request		HttpServletRequest
	 */

	private void initializeAction(Action action,HttpServletRequest request){

		try {
		  BeanInfo info = Introspector.getBeanInfo(action.getClass());
		  PropertyDescriptor[] pds = info.getPropertyDescriptors();
		  for (int i = 0 ; i < pds.length ; i++) {
			PropertyDescriptor pd = pds[i];
			if (pd.getPropertyType() == String.class &&
			    pd.getWriteMethod() != null) {
			      pd.getWriteMethod().invoke(action,
				new Object[]{request.getParameter(pd.getName())});
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	/**
	 * Invoked from the service() and this selects the correct directory
	 * for the JSP based on the requested content type.
	 * 
	 * @param appSession		ApplicationSession
	 * @param request		HttpServletRequest
	 * @param response		HttpServletResponse
	 * @param result		ActionResult
	 * @exception ServletException
	 * @exception IOException
	 */

	private void forwardToJSP(ApplicationSession appSession,
		HttpServletRequest request, HttpServletResponse response,
		ActionResult result) throws ServletException, IOException {

                // Simple debugging information about the incoming header. 
		if (debug) {
		  Enumeration e = request.getHeaderNames();
		  while (e.hasMoreElements()) {
		    String name = (String)e.nextElement();
		    String value = request.getHeader(name);
		    System.out.println("Name= " + name + ", value= " + value);
		  }
	  	  System.out.println("URI: " + request.getRequestURI());
		}

                // uses the code from frameWork.webFramework.jspSelection
		RuleBasedJSPSelector selector = new RuleBasedJSPSelector
					(getServletContext(), request);

               /*
                * Uses the framework to select the correct directory for the
                * jsp based on the incoming device.  It then uses this to send
                * back to the mobile device.
                */
		String fullJspName = selector.selectJSP(result.getJSP());
		if (debug)
		  System.out.println("fullJSPname:"+fullJspName);

		RequestDispatcher rd =
			getServletContext().getRequestDispatcher(fullJspName);

		request.setAttribute("values", result.getValues());
		request.setAttribute("appSession", appSession);

                // useful for getting the stock price back to the jsp.
		request.setAttribute("message", result.getMessage());
		request.setAttribute("oldFormValues",result.getOldFormValues());

		rd.forward(request, response);    
	}

}
