package stockDemo.ui.session;

import javax.servlet.http.*;
import java.io.*;

/** 
 * Responsible for creating the ApplicationSession and retrieving it
 * from the HttpSession 
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ApplicationSessionManager implements Serializable {
    
    private HttpServletRequest request;
    private HttpServletResponse response;
    private static final String APP_SESSION_NAME = "appSession";

    public ApplicationSessionManager(HttpServletRequest request,
				     HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }
    
    /**
     * Retrieves the ApplicationSession from the HttpSession creating one
     * if necessary
     * 
     * @return appSession 
     */
    public ApplicationSession getSession() {

        HttpSession session = request.getSession(true);
        ApplicationSession appSession = 
		(ApplicationSession)session.getAttribute(APP_SESSION_NAME);

        if (appSession == null) {
            appSession = new ApplicationSession();
            session.setAttribute(APP_SESSION_NAME, appSession);
        }

        return appSession;
    }
}
