package travelDemo.reservations;

import java.util.*;

/**
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class Itinerary {
    
    private Vector outboundFlights = new Vector();
    private Vector returnFlights = new Vector();
    private double totalPrice = 1245;

    public double getTotalPrice() {
	return totalPrice;
    }

    public void addOutboundFlight(Flight flight) {
	outboundFlights.addElement(flight);
    }

    public Flight getFirstOutboundFlight() {
	return (Flight)outboundFlights.firstElement();
    }

    public Flight getLastOutBoundFlight() {
	return (Flight)outboundFlights.lastElement();
    }

    public Flight getFirstReturnFlight() {
	return (Flight)returnFlights.firstElement();
    }

    public Flight getLastReturnFlight() {
	return (Flight)returnFlights.lastElement();
    }


    public void addReturnFlight(Flight flight) {
	returnFlights.addElement(flight);
    }

    public Enumeration getOutboundFlights() {
	return outboundFlights.elements();
    }

    public Enumeration getReturnFlights() {
	return returnFlights.elements();
    }

    public boolean isRoundTrip() {
	return !returnFlights.isEmpty();
    }
}
