package travelDemo.reservations;

import java.util.*;
/**
 * Client-side facade to the (non-existent) ReservationsService EJB
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ReservationsServiceClientWrapper {
    private static ReservationsServiceClientWrapper theInstance = new ReservationsServiceClientWrapper();
    
    public static ReservationsServiceClientWrapper getInstance() {
	return theInstance;
    }

    /**
     * Find the best fares between the two cities
     * 
     * @param origin
     * @param destination
     * @return fares 
     * @exception ReservationsServiceException
     */
    public BestFaresCollection findBestFares(String origin, String destination)
    	throws ReservationsServiceException {
    
	// 
    	// This should really be in an EJB!
	//

        if (!origin.equalsIgnoreCase("sfo") || !destination.equalsIgnoreCase("ewr"))  {
	    throw new NoFaresAvailable();
	} else {    
	    BestFaresCollection fares = new BestFaresCollection(origin, destination);
	    fares.add(new Fare("U. Airlines", 500));
	    fares.add(new Fare("B. Airways", 510));
	    fares.add(new Fare("A. West", 520));
	    return fares;
	}
    }

    /**
     * Find itineraries that match the search criteria
     * 
     * @param criteria
     * @return ic
     * @exception ReservationsServiceException
     */
    public ItineriesCollection findBestItineries(FlightSearchCriteria criteria)     	
	throws ReservationsServiceException {       
    	
	// This should really be in an EJB
	
	ItineriesCollection ic = new ItineriesCollection();
	Itinerary it = new Itinerary();
	it.addOutboundFlight(new Flight("UA", "1234", "OAK", "DEN", new Date(), new Date()));
	it.addReturnFlight(new Flight("UA", "5678", "DEN", "OAK", new Date(), new Date()));
	ic.add(it);
	return ic;
    }
}
