package travelDemo.ui.actions;

import travelDemo.ui.session.*;
import travelDemo.reservations.*;
import webFramework.actions.*;

/**
 * Finds the best fares and displays them
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class DisplayBestFaresAction extends LoginRequiredAction {
        
    private ApplicationSession appSession;

    public DisplayBestFaresAction(ApplicationSession appSession) {
	super(appSession);
	this.appSession = appSession;
    }

    private String origin;
    private String destination;

    public void setOrigin(String origin) {
	this.origin = origin;
    }

    public void setDestination(String destination) {
	this.destination = destination;
    }

    public ActionResult performAction() {
	// Validate the parameters
	
	if (origin == null || destination == null 
	    || origin.equals("") || destination.equals("")) {
    	    ActionResult ar = new ActionResult("bestFaresError.jsp");
	    ar.setMessage("Please fill in the form correctly");
	    ar.setOldFormValues(new DisplayBestFaresFormValues(origin, destination));
	    return ar;       
	}

	appSession.setLastOrigin(origin);
	appSession.setLastDestination(destination);

    	// Invoke the business logic and create an ActionResult

	try {
	    BestFaresCollection fares = ReservationsServiceClientWrapper.getInstance().findBestFares(origin, destination);
            ActionResult ar = new ActionResult("displayFares.jsp");                        
	    ar.setValues(fares);
	    return ar;
	} catch (NoFaresAvailable e) {
            ActionResult ar = new ActionResult("noBestFares.jsp");
	    ar.setMessage("No best fares between these places");
	    ar.setOldFormValues(new DisplayBestFaresFormValues(origin, destination));
	    return ar;
	} catch (ReservationsServiceException e) {
	    ActionResult ar = new ActionResult("noBestFares.jsp");
	    ar.setMessage("SystemError:" + e.getClass());
	    ar.setOldFormValues(new DisplayBestFaresFormValues(origin, destination));
	    return ar;
	}
     }
} 
