package travelDemo.ui.actions;

import travelDemo.ui.session.*;

import travelDemo.reservations.*;
import webFramework.actions.*;


/**
 * Handles the second part of the form and displays the best itineraries
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class DisplayBestItinerariesAction extends LoginRequiredAction {
    private ApplicationSession appSession;
    private DateParameter returnDate = new DateParameter();
    private IntParameter returnTime = new IntParameter(1, 12);
    private StringParameter returnAmPm = new StringParameter();

    public DisplayBestItinerariesAction(ApplicationSession appSession) {
	super(appSession);
	this.appSession = appSession;
    }
    
    public void setReturnDate(String returnDate) {
	this.returnDate.setStringValue(returnDate);
    }

    public void setReturnTime(String returnTime) {
	this.returnTime.setStringValue(returnTime);
    }

    public void setReturnAmPm(String returnAmPm) {
	this.returnAmPm.setStringValue(returnAmPm);
    }

    private ActionResult badField(String name) {
	ActionResult result = new ActionResult("flightSearchFormError.jsp");
	result.setMessage("Bad field: " + name);
	return result;
    }
    private ActionResult validate() {
	if (!returnDate.validate()) {
	    return badField("returnDate");
	}

	if (!returnTime.validate()) {
	    return badField("returnTime");
	}
	if (!returnAmPm.validate()) {
	    return badField("returnAmPm");
	}
	return null;
    }
    
    public ActionResult performAction() {
	ActionResult are = validate();
	if (are != null) return are;

	FlightSearchCriteria c = appSession.getSearchCriteria();
	c.setReturnDate(returnDate.getValue());
	c.setReturnTime(returnTime.getValue());
	c.setReturnAmPm(returnAmPm.getValue());
        
	try {
	    ItineriesCollection fares = ReservationsServiceClientWrapper.getInstance().findBestItineries(c);
            ActionResult ar = new ActionResult("displayBestItineraries.jsp");                        
	    ar.setValues(fares);
	    return ar;
	} catch (ReservationsServiceException e) {
	    ActionResult ar = new ActionResult("noBestItineries.jsp");
	    ar.setMessage("SystemError:" + e.getClass());
	    //ar.setOldFormValues(new DisplayBestFaresFormValues(origin, destination));
	    return ar;
	}
     }
        
}
 
