package travelDemo.ui.actions;

import travelDemo.ui.session.*;
import travelDemo.reservations.*;
import webFramework.actions.*;

/**
 * Handles the submission of the first part of the form and saves it.
 * Displays the second part of the form
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class FindFlightBestItineriesDestinationAction extends LoginRequiredAction {
    private ApplicationSession appSession;

    private StringParameter type = new StringParameter();
    private IntParameter passengers = new IntParameter(0, 4);
    private IntParameter children = new IntParameter(0, 4);
    private StringParameter origin = new StringParameter();
    private DateParameter departureDate = new DateParameter();
    private IntParameter departureTime = new IntParameter(1, 12);
    private StringParameter departureAmPm = new StringParameter();
    private StringParameter destination = new StringParameter();

    public FindFlightBestItineriesDestinationAction(ApplicationSession appSession) {
	super(appSession);
	this.appSession = appSession;
    }
    public void setType(String type) {
	this.type.setStringValue(type);
    }

    public void setPassengers(String passengers) {
	this.passengers.setStringValue(passengers);
    }

    public void setChildren(String children) {
	this.children.setStringValue(children);
    }

    public void setOrigin(String origin) {
	this.origin.setStringValue(origin);
    }

    public void setDepartureDate(String departureDate) {
	this.departureDate.setStringValue(departureDate);
    }

    public void setDepartureTime(String departureTime) {
	this.departureTime.setStringValue(departureTime);
    }

    public void setDepartureAmPm(String departureAmPm) {
	this.departureAmPm.setStringValue(departureAmPm);
    }

    public void setDestination(String destination) {
	this.destination.setStringValue(destination);
    }

    private ActionResult badField(String name) {
	ActionResult result = new ActionResult("flightSearchFormError.jsp");
	result.setMessage("Bad field: " + name);
	return result;
    }
    private ActionResult validate() {
	if (!type.validate()) {
	    return badField("type");
	}

	if (!passengers.validate()) {
	    return badField("Passengers");
	}

	if (!children.validate()) {
	    return badField("children");
	}

	if (!origin.validate()) {
	    return badField("origin");
	}

	if (!destination.validate()) {
	    return badField("destination");
	}

	if (!departureDate.validate()) {
	    return badField("departureDate");
	}

	if (!departureTime.validate()) {
	    return badField("departureTime");
	}
	if (!departureAmPm.validate()) {
	    return badField("departureAmPm");
	}
	return null;
    }
    
    public ActionResult performAction() {
	ActionResult ar = validate();
	if (ar != null) return ar;

	FlightSearchCriteria c = new FlightSearchCriteria();
	c.setType(type.getValue());
	c.setPassengers(passengers.getValue());
	c.setChildren(children.getValue());
	c.setOrigin(origin.getValue());
	
	c.setDepartureDate(departureDate.getValue());
	c.setDepartureTime(departureTime.getValue());
	c.setDepartureAmPm(departureAmPm.getValue());

	c.setDestination(destination.getValue());

	appSession.setSearchCriteria(c);

	return new ActionResult("findFlightBestItineriesDestination.jsp");
    }
        
} 

