package travelDemo.ui.actions;

import travelDemo.ui.session.*;
import travelDemo.userService.*;
import webFramework.actions.*;

/**
 * Verify that the user Id and password are ok and display the home page.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class LoginAndDisplayHomePageAction extends BaseAction {

	private ApplicationSession appSession;

	private String userId;
	private String password;

	private static final boolean debug = false;

	public LoginAndDisplayHomePageAction(ApplicationSession appSession) {
		this.appSession = appSession;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public ActionResult performAction() {
		if (appSession.isLoggedIn()) {
			if (debug)
			  System.out.println("Already logged in!");
			return new ActionResult("home.jsp");
		}

		// Validate the form fields

		if (userId == null || userId.equals("") || 
			password == null || password.equals("")) {
			ActionResult result = new ActionResult("loginError.jsp");
			result.setMessage("Bad format userId/password");
			return result;
		}

		// Check the password

		try {
			UserServiceClientWrapper.getInstance().checkPassword(userId, password);
		} catch (BadPasswordException e) {
			ActionResult result = new ActionResult("loginError.jsp");
			result.setMessage("Bad userId/password");
			return result;
		} catch (Exception e) {
			ActionResult result = new ActionResult("loginError.jsp");
			result.setMessage("SystemError:" + e.getClass());
			return result;
		}

		// Update the session state to remember we are logged in
		appSession.setUserId(userId);

		return new ActionResult("home.jsp");
	}

}
