package travelDemo.ui.actions;

import travelDemo.ui.session.*;
import webFramework.actions.*;

/**
 * Base class for actions that require the user to be logged in
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public abstract class LoginRequiredAction extends BaseAction {
    private ApplicationSession appSession;

    public LoginRequiredAction(ApplicationSession appSession) {
	this.appSession = appSession;
    }

    /**
     * Checks that the user is logged if. If they are not then
     * return an ActionResult that displays loginRequired.jsp
     * 
     * @return ActionResult
     */
    public ActionResult check() {
        if (!appSession.isLoggedIn()) {
	    return new ActionResult("loginRequired.jsp");
	} else
	    return null;
    }
}
