package travelDemo.ui.actions; 
 
import travelDemo.ui.session.*; 
import travelDemo.reservations.*; 
import java.util.*; 
import webFramework.actions.*; 
 
/** 
 * Stub action that simulates calling the business logic 
 * It could have parameters too.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */
 
public class StubbedDisplayBestItinerariesAction implements Action { 
         
    private ApplicationSession appSession; 
    private String type = "r"; 
 
    public StubbedDisplayBestItinerariesAction(ApplicationSession appSession) { 
	this.appSession = appSession; 
    } 
 
    public void setType(String type) { 
	this.type = type; 
    } 
 
    public ActionResult execute() { 
	// Create dummy test data 
	ItineriesCollection ic = new ItineriesCollection(); 
	Itinerary it = new Itinerary(); 
	it.addOutboundFlight(new Flight("UA", "1234", "OAK", "DEN", new Date(), new Date())); 
	if (type == null || type.equals("r")) { 
	    it.addReturnFlight(new Flight("UA", "5678", "DEN", "OAK", new Date(), new Date())); 
	} 
	ic.add(it); 
	ActionResult ar = new ActionResult("displayBestItineraries.jsp");                         
	ar.setValues(ic); 
	return ar; 
    } 
} 
