package travelDemo.ui.formatters;

import travelDemo.reservations.*;
import java.util.*;
import java.text.*;

/**
 * Implements the formatting for displaying an itinerary
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ItinerarySummaryFormatter {
    private Itinerary itinerary;

    public ItinerarySummaryFormatter(Itinerary itinerary) {
	this.itinerary = itinerary;
    }

    public String getOrigin() {
	return itinerary.getFirstOutboundFlight().getOrigin();
    }

    public String getDestination() {
	return itinerary.getLastOutBoundFlight().getDestination();
    }

    public String getOutboundDepartureTime() {
	return formatDate(itinerary.getFirstOutboundFlight().getDepartureTime(),
			  new Date(),
			  true);
    }

    private String formatDate(Date d, Date relative, boolean needDay) {
	Calendar c = Calendar.getInstance();
	c.setTime(d);
	Calendar rc = Calendar.getInstance();
	rc.setTime(relative);
	String formatString;
	if (c.get(Calendar.YEAR) != rc.get(Calendar.YEAR))
	    formatString = "hh:mm a, EE MMM dd yy";
	else if (!needDay && c.get(Calendar.MONTH) == rc.get(Calendar.MONTH) && c.get(Calendar.DAY_OF_MONTH) == rc.get(Calendar.DAY_OF_MONTH))
	    formatString = "hh:mm a";
	else
	    formatString = "hh:mm a, EE MMM dd";
	SimpleDateFormat f = new SimpleDateFormat(formatString);
	return f.format(d);
    }

    public String getOutboundArrivalTime() {
	return formatDate(itinerary.getLastOutBoundFlight().getArrivalTime(),
			  itinerary.getFirstOutboundFlight().getDepartureTime(),
			  false);
    }

    public String getReturnDepartureTime() {
	return formatDate(itinerary.getFirstReturnFlight().getDepartureTime(),
			  new Date(),
			  true);
    }

    public String getReturnArrivalTime() {
	return formatDate(itinerary.getFirstReturnFlight().getArrivalTime(),
			  itinerary.getFirstReturnFlight().getDepartureTime(),
			  false);
    }
}
