package travelDemo.ui.servlets;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.IOException;
import java.util.*;

import travelDemo.ui.session.*;
import webFramework.jspSelection.*;

/**
 * BaseServlet class: defines a forwardToJSP() method and implements
 * service() to retrieve the ApplicationState and call serviceWithState()
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public abstract class BaseServlet extends HttpServlet {

    private static final boolean debug = false;
    
    protected void forwardToJSP(ApplicationSession appSession,
	HttpServletRequest request, HttpServletResponse response,
	String jsp, Object values) throws ServletException, IOException {

       forwardToJSP(appSession, request, response, jsp, values, null, null);
    }
          
    /**
     * Invoked from the service() and this selects the correct directory
     * for the JSP based on the requested content type.
     *
     * @param appSession		ApplicationSession
     * @param request			HttpServletRequest
     * @param response			HttpServletResponse
     * @param jsp			String
     * @param values			Object 
     * @param oldFormValues		Object
     * @param message			String 
     * @exception IOException
     * @exception ServletException
     */

   protected void forwardToJSP(ApplicationSession appSession,
	HttpServletRequest request, HttpServletResponse response, 
	String jsp, Object values, Object oldFormValues, String message) 
			throws ServletException, IOException {

	if (debug) {
          Enumeration e = request.getHeaderNames();
          while (e.hasMoreElements()) {
              String name = (String)e.nextElement();
              String value = request.getHeader(name);
              System.out.println("Name= " + name + ", value= " + value);
          }
        }

	RuleBasedJSPSelector selector = 
		new RuleBasedJSPSelector(getServletContext(), request);

	String fullJspName = selector.selectJSP(jsp);

        RequestDispatcher rd =
		getServletContext().getRequestDispatcher(fullJspName);

        request.setAttribute("values", values);
        request.setAttribute("appSession", appSession);
        request.setAttribute("message", message);
        request.setAttribute("oldFormValues", oldFormValues);

        rd.forward(request, response);    
   }

    /**
     * Gets the ApplicationState and calls serviceWithState()
     * 
     * @param request			HttpServletRequest
     * @param response			HttpServletResponse
     * @exception IOException
     * @exception ServletException
     */
    public final void service(HttpServletRequest request,
	HttpServletResponse response) throws IOException, ServletException {

        ApplicationSessionManager asm =
		new ApplicationSessionManager(request, response);
        ApplicationSession appSession = asm.getSession();
        serviceWithState(appSession, request, response);
    }
    
    /**
     * Subclass must implement this
     * 
     * @param appSession		ApplicationSession
     * @param request			HttpServletRequest
     * @param response			HttpServletResponse
     * @exception IOException
     * @exception ServletException
     */
    protected abstract void serviceWithState(ApplicationSession appSession,
	HttpServletRequest request, HttpServletResponse response)
	        throws IOException, ServletException;
} 
