package travelDemo.ui.servlets;

import java.io.*;

import webFramework.util.*;
import webFramework.deviceManagement.*;

import javax.servlet.http.*;
import javax.servlet.*;
import java.util.*;



/**
 * ShowInfoServlet displays information about the incoming device back to
 * the device. Shows what the values are for at least these and possibly more
 * depending on the device:
 * 	Accept
 *	Accept-Language
 *	Accept-Encoding
 *	User-Agent
 *	Host
 *	Connection
 *	Cookie 
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ShowInfoServlet extends HttpServlet {
        
    public void service(HttpServletRequest request,
			HttpServletResponse response)
        throws IOException, ServletException {


	ServletContext context = getServletContext();
	Device device = null;

	// Get the device manager and device from the webFramework to
	// find out the type of device coming in.
	DeviceSpecManager dsm = DeviceSpecManager.getInstance(context);
	try {
		device = dsm.findDevice(request);
	} catch (IOException e) {
		e.printStackTrace();
	}

	// Set the response type based on the incoming device
	response.setContentType(device.getContentType());

	String test = device.getContentType();

	PrintWriter out = response.getWriter();

	if (test.equals("text/html"))  {
	   out.println("<html>");
	   out.println("<body>");
	}

	if (test.equals("text/vnd.wap.wml")) {
	   out.println("<?xml version=\"1.0\"?>");
	   out.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
	   out.println("<wml>");
	   out.println("<card>");
	}

	Enumeration e = request.getHeaderNames();

	while (e.hasMoreElements()) {

		String name = (String)e.nextElement();
		String value = request.getHeader(name);

		// We really don't care about the Accept-Charset, so ignore 
		// it since it's pretty large and on some phones would go
		// over the # characters limit of the phone...
		if (name.equals("Accept-Charset"))
			continue;

		out.println("<p>");
		out.println(name + ", value= " + value);
		out.println("</p>");
	}

	if (test.equals("text/html"))  {
	   out.println("</body>");
	   out.println("</html>");
	}

	if (test.equals("text/vnd.wap.wml")) {
	   out.println("</card>");
	   out.println("</wml>");
	}

    }
    
} 
