package travelDemo.ui.session;

import java.io.Serializable;
import travelDemo.reservations.*;

/** 
 * Maintains the web-related appSession of the application which for the time
 * being is just the userId, and the last entered origin and destination cities.
 *
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class ApplicationSession {
    private String userId;
    private String lastOrigin;
    private String lastDestination;
    private FlightSearchCriteria searchCriteria;

    public void setUserId(String userId) {
        this.userId = userId;
    }
    
    public String getUserId() {
        return userId;
    }
    
    public boolean isLoggedIn() {
        return userId != null;
    }

    public void setLastOrigin(String origin) {
	this.lastOrigin = origin;
    }

    public String getLastOrigin() {
	return lastOrigin;
    }

    public void setLastDestination(String destination) {
	this.lastDestination = destination;
    }

    public String getLastDestination() {
	return lastDestination;
    }

    public void logout() {
	userId = null;
    }

    public void setSearchCriteria(FlightSearchCriteria searchCriteria) {
	this.searchCriteria = searchCriteria;
    }
    public FlightSearchCriteria getSearchCriteria() {
	return searchCriteria;
    }

}
