package travelDemo.userService;

import javax.naming.*;
import java.rmi.*;
import java.util.*;
import javax.ejb.*;

/**
 * @author Copyright (c) 2001 by BEA Systems, Inc. All Rights Reserved.
 */

public class UserServiceClientWrapper {
	private static UserServiceClientWrapper theInstance = new UserServiceClientWrapper();
	public static UserServiceClientWrapper getInstance() {
		return theInstance;
	}

	// Invoke business logic.
	private Context getInitialContext() throws NamingException {
		Properties h = new Properties();
		h.put(Context.INITIAL_CONTEXT_FACTORY,  "weblogic.jndi.WLInitialContextFactory");
		return new InitialContext(h);
	}

	public void checkPassword(String userId, String password) throws UserServiceException {
		try {
		Context ctx = getInitialContext();
		try {
			UserServiceHome home = (UserServiceHome)ctx.lookup("travelDemo.userService.UserServiceHome");
			UserService service = home.create();
			service.checkPassword(userId,password);
		} finally {
			ctx.close();
		}
		} catch (NamingException e) {
			throw new UserServiceSystemException(e);
		} catch (RemoteException e) {
			throw new UserServiceSystemException(e);
		} catch (CreateException e) {
			throw new UserServiceSystemException(e);
		}
	}
}
