package examples.wlec.ejb.simpapp;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * The methods in this interface are the public face of
 * <font face="Courier New" size=-1>ConverterBean</font>.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a <font face="Courier New" size=-1>java.rmi.RemoteException</font>.
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject <font face="Courier New" size=-1>ConverterBeanE</font>
 * implements this interface and delegates to the bean.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Converter extends EJBObject {

  /**
   * Converts to uppercase.
   *
   * @param inData            string input data
   * @return                  ConverterResult conversion Result
   * @exception               ProcessingErrorException
   *                          if there is an error while converting the string
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public  ConverterResult toUpper (String inData)
    throws ProcessingErrorException, RemoteException;

  /**
   * Converts to lowercase.
   *
   * @param inData            string input data
   * @return                  ConverterResult conversion result
   * @exception               ProcessingErrorException
   *                          if there is an error while converting the string
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   */
  public ConverterResult toLower (String inData)
    throws ProcessingErrorException, RemoteException;
}
