package examples.wlec.ejb.simpapp;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * This interface is the home interface for the
 * <font face="Courier New" size=-1>ConverterBean.java</font>,
 * which in WebLogic is implemented by the code-generated container
 * class <font face="Courier New" size=-1>ConverterBeanC</font>.
 * A home interface may support one or more <font face="Courier New" size=-1>create</font>
 * methods, which must correspond to methods named "ejbCreate" in the EJBean.
 *
 * @author Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface ConverterHome extends EJBHome {

  /**
   * This method corresponds to the <font face="Courier New" size=-1>ejbCreate</font>
   * method in the bean <font face="Courier New" size=-1>ConverterBean.java</font>.
   * The parameter sets of the two methods are identical. When the client calls the
   * <font face="Courier New" size=-1>ConverterHome.create</font> method, the container
   * allocates an instance of the EJBean and calls the
   * <font face="Courier New" size=-1>ejbCreate</font> method.
   *
   * @return                  Converter
   * @exception               RemoteException if there is
   *                          a communications or systems failure
   * @exception               CreateException
   *                          if there is a problem creating the bean
   * @see                     examples.wlec.ejb.simpapp.ConverterBean#ejbCreate
   */
  Converter create() throws CreateException, RemoteException;
}
