<%
/*
 *This JSP file illustrates how a WebLogic Server can connect to WebLogic Enterprise through 
 *an EJBean which then invokes an operation on a CORBA object. This jsp can either be called directly
 *from the browser or through the <font face="Courier New" size=-1>ejbSimpapp.html</font> file. 
 *Following event takes place when you run the example: 
 *<UL>
 *<LI>When the user submits the form, the appropriate method on the remote object is called.
 *<LI>This request goes through the ISL/ISH to the appropriate server in the WebLogic Enterprise domain.
 *<LI>The server converts the string and sends it back to the EJBean which in turn sends it to the jsp.
 *<LI>The jsp returns the converted string to the client browser within some generated HTML.
 *</UL>
 *
 *Copyright (c) 1999-2001 by BEA Systems, Inc. All Rights Reserved.-->
 */
%>

<html>
<head>
<title>Weblogic Enterprise Connectivity - Simpapp EJB Sample</title>
</head>
<body bgcolor=#8B129C>
<p><img src=images/BEA_Button_Final_web.gif align=right>
<h2>
<font color=#FFFFFF>
Weblogic Enterprise Connectivity - Simpapp EJB Sample
</font>
</h2>

<%@ page import="
    javax.servlet.*,
    javax.servlet.http.*,
    java.io.*,
    java.util.Properties,
    javax.ejb.*,
    javax.naming.*,
    java.rmi.RemoteException,
    java.util.*,
    examples.wlec.ejb.simpapp.*
"%>

<%
  // A simple jsp implementation, in which we get the remote EJObject from the EJB Home and then 
  // invoke the <font face="Courier New" size=-1>toLower</font> or <font face="Courier New" size=-1>toUpper</font>
  // method (as requested by the user), construct a jsp page and print the user string in uppercase or lowercase.  
  // See the provided <font face="Courier New" size=-1>ejbSimpapp.html</font> for the HTML form used to submit
  // the data.

  final String defaultCase = "UPPER";
  final String defaultString = "It Works";

  ConverterResult result;
  
  // Read the input data 
    String mixed = (String) request.getParameter("InData");
    String changeCase = (String) request.getParameter("ChangeCase");
    String user = (String) request.getParameter("user");
    String password = (String) request.getParameter("password");

    if(user!=null && password!=null)  	
   	{
%>


<p><font color=#FFFFFF>"Note: Using the user: "<%= user %> "and password: "<%= password %></font>

<%
	} 
	else	{
%>

<p><font color=#FFFFFF>"Note: No user and password credentials"</font>

<%
	}
  // If no string is passed, use the default string
	if ((mixed == null) || (mixed.length() <= 0)) {
	mixed = defaultString;
%>

<p><font color=#FFFFFF>"Note: Using the default data: "<%= mixed %></font>

<%
	}
  // If no case is passed, convert to UPPERCASE
	if ((changeCase == null) || (changeCase.length() <= 0)) {
	changeCase = defaultCase;
%>

<p><font color=#FFFFFF>"Note: Using the default action: "<%= changeCase %></font>

<%
    }

    try {

      // Create a converter object, which will later help us do conversion
      Context ctx = getInitialContext(user, password);
      ConverterHome converterH = (ConverterHome) ctx.lookup("simpapp.ConverterHome");

      Converter converter = converterH.create();

      try {
        if (changeCase.equals(defaultCase)) {
          // To Upper
          result = converter.toUpper(mixed);
        }
        else
        {
          // To lower
          result = converter.toLower(mixed);
        }  
%>

<p><font color=#FFFFFF>"Output String: "<%= result.outData %></font>

<%
      }
      catch (ProcessingErrorException pe) {
        out.print("Processing Error: " + pe);
        return;
      } 
      catch (Exception e) {
        out.print(":::::::::::::: Error :::::::::::::::::");
        return;
      }

      if (converter != null) {
        try {
          // Remove converter
          converter.remove();
        }
        catch (Exception e) {
          out.print("Error removing converter ");
          return;
        }
      }
    }
    catch (Exception e) {
      out.print(":::::::::::::: Error :::::::::::::::::");
      return;
    }
%>

<%!
    //Gets an initial context.
    //return		Context
    //exception         java.lang.Exception if there is an error in getting a Context
  

  static public Context getInitialContext(String user, String password) 
  throws Exception {
    Properties p = new Properties();
    p.put(Context.INITIAL_CONTEXT_FACTORY,
      "weblogic.jndi.WLInitialContextFactory");
    if (user != null) {
      p.put(Context.SECURITY_PRINCIPAL, user);
      if (password == null) 
        password = "";
      p.put(Context.SECURITY_CREDENTIALS, password);
    } 
    return new InitialContext(p);
  }
%>

<p>
<font size=-1>Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.
</font>

</body>
</html>







