package jsp_servlet;

import java.io.*;
import java.util.Properties;

import weblogic.html.*;

import org.omg.CORBA.*;
import com.beasys.Tobj.*;
import com.beasys.*;

/* These come from WebLogic Enterprise University sample */
import UniversityT.RegistrarFactory;
import UniversityT.RegistrarFactoryHelper;
import UniversityT.Registrar;

/**
 * This example demonstrates how a WebLogic Servlet can connect to BEA Tuxedo
 * and invoke operations on CORBA objects. This example contains a set of
 * methods which are called by the jsp servlets that are included as
 * part of this sample.
 * <UL>
 * <LI>When the Weblogic Server comes up, it opens multiple connections
 * to the BEA Tuxedo IIOP Listener/Handler.
 * <LI>The servlet picks up a connection from the WLEC connection pool; that is,
 * it acts as a BEA Tuxedo CORBA client and gets a client context from the Bootstrap object.
 * <LI>The servlet then finds the FactoryFinder object and uses the Registrar factory
 * to get the Registrar object.
 * <LI>When the user submits the form, the appropriate operation is 
 * invoked. This request goes through the IIOP Listener/Handler to the appropriate  
 * CORBA server in the BEA Tuxedo domain.
 * <LI>The CORBA server performs the requested operation and sends the 
 * data back to the servlet.
 * <LI>The servlet returns the data to the client
 * browser within some generated HTML.
 * </UL>
 *
 * @author Copyright (c) 1999-2001 BEA Systems, Inc.  All rights reserved.
 */

public class UniversityHelper {

  public UniversityT.Registrar gRegistrarObjRef;
  public UniversityT.StudentDetails gStudentDetails;
  public org.omg.CosTransactions.Current gTransCur = null;

  /**
  * Since there is no way to override the
  * <font face="Courier New" size=-1>init</font> method, we need
  * to come up with a local initialization method which can be called
  * from a jsp servlet. It initializes the servlet.  Here, we
  * get the Bootstrap object, the Factory Finder and the Registrar factory
  * during the startup.
  * 
  * @exception               Exception if the servlet fails
  */
  public void univInit() throws Exception
  {
    byte[] userData = new byte[0];
    String clientName = "university_client";

    try {
		
      // Create the bootstrap object,
      Tobj_Bootstrap bootstrap = 
        BootstrapFactory.getClientContext("Univpool");
			
      // Resolve Factory Finder
      org.omg.CORBA.Object Off =
        bootstrap.resolve_initial_references("FactoryFinder");

      // Narrow the factory finder.
      FactoryFinder Ff = FactoryFinderHelper.narrow(Off);
     		 
      // Find Factory by id
      org.omg.CORBA.Object Of =
        Ff.find_one_factory_by_id(UniversityT.RegistrarFactoryHelper.id());
	
      // Narrow the factory.
      UniversityT.RegistrarFactory F = 
        UniversityT.RegistrarFactoryHelper.narrow(Of);

      // Ask the "RegistrarFactory" to create a Registrar object
      gRegistrarObjRef = F.find_registrar();
      	
      if (gRegistrarObjRef == null)
      {
        System.err.println("factory returned nil");
        throw new Exception();
      }
	
      // Get the Transaction Current Object
      try
      {
        org.omg.CORBA.Object transCurObj = 
          bootstrap.resolve_initial_references("TransactionCurrent");
        gTransCur = org.omg.CosTransactions.CurrentHelper.narrow(transCurObj);
      }
      catch(com.beasys.Tobj.InvalidName e)
      {
        System.err.println("Invalid name: " + e);
        throw new Exception(e.toString());
      }
    }
    catch (org.omg.CosLifeCycle.NoFactory e) {
      System.err.println("Can't find the Registrar factory: " +e);
      throw new Exception(e.toString());
    }
    catch (CannotProceed e) {
      System.err.println("FactoryFinder internal error: " +e);
      throw new Exception(e.toString());
    }
    catch (RegistrarNotAvailable e) {
      System.err.println("FactoryFinder Registrar not available: " +e);
      throw new Exception(e.toString());
    }
    catch (InvalidName e) {
      System.err.println("Invalid name from resolve_initial_reference(): " +e);
      throw new Exception(e.toString());
    }
    catch (org.omg.CORBA.BAD_PARAM e) {
      System.err.println("Invalid TOBJADDR=//host:port property specified: " +e);
      throw new Exception(e.toString());
    }
    catch (org.omg.CORBA.UserException e) {
      System.err.println("Unexpected CORBA user exception: " +e);
      throw new Exception(e.toString());
    }
    catch (org.omg.CORBA.SystemException e) {
      System.err.println("CORBA system exception: " +e);
      throw new Exception(e.toString());
    }
  }

  // Return the TransactionCurrent object to the jsp servlet
  
  public org.omg.CosTransactions.Current getTransCur() 
  {
    return gTransCur;
  }

  // Verifiy the student by invoking an operation on the Registrar object
  // which is a CORBA object.

  public boolean verifyStudent(String studentIden) throws Exception
  {

    int studentId = Integer.parseInt (studentIden);
    boolean validId = true;

    try
    {
    // Invoke the appropriate operation on the Registrar object to get the
    // student details
      gStudentDetails = 
        gRegistrarObjRef.get_student_details(studentId);
    }
    catch(org.omg.CORBA.OBJ_ADAPTER e)
    {
      validId = false;
    }
    catch(org.omg.CORBA.NO_IMPLEMENT e)
    {
      validId = false;
    }
    catch(org.omg.CORBA.BAD_PARAM e)
    {
      validId = false;
    }
    catch(org.omg.CORBA.SystemException e)
    {
      validId= false;
      throw new Exception(e.toString());
    }
    return validId;
  }

  // Get a list of courses based on a selection criteria.

  public UniversityT.CourseSynopsis[] get_courses(String aCriteria) throws Exception
  {
    final int CHUNK_SIZE = 0;

    org.omg.CORBA.IntHolder numberRemaining = new org.omg.CORBA.IntHolder();
    UniversityT.CourseSynopsisEnumeratorHolder theRest =
      new UniversityT.CourseSynopsisEnumeratorHolder();
    UniversityT.CourseSynopsis[] listOfCourses = null;
	
    try {
      listOfCourses =
      gRegistrarObjRef.get_courses_synopsis(aCriteria, CHUNK_SIZE,
      numberRemaining, theRest);
    }

    catch(org.omg.CORBA.SystemException e)
    {
      throw new Exception(e.toString());
    }
    return listOfCourses;
  }

  // Get the details of a course.

  public UniversityT.CourseDetails[] get_course_details(String courseNum) 
    throws Exception
  {
    int[] selectedCourses;
    selectedCourses = new int[1];
	
    int course_num = Integer.parseInt (courseNum);
    UniversityT.CourseDetails[] details=null;
    selectedCourses[0] = course_num;
	
    try
    {
      // Do the invoke on the Registrar object to get the
      // course details from the CORBA server
      details =
        gRegistrarObjRef.get_courses_details(selectedCourses );
    }
    catch(org.omg.CORBA.SystemException e)
    {
      throw new Exception(e.toString());
    }
    return details;
  }
}
