<%
/*
 * Copyright (c) 1999-2001 BEA Systems, Inc.  All rights reserved
 *
 * THIS IS SOURCE CODE PUBLISHED FOR DEMONSTRATION PURPOSES
 *
 * This JSP file illustrates how an Internet client uses a servlet
 * to invoke operations on a BEA Tuxedo CORBA object.
    org.omg.CORBA.*,
 */
%>

<%@ page import="
    com.beasys.Tobj.*,
    com.beasys.*,
    UniversityT.RegistrarFactory,
    UniversityT.RegistrarFactoryHelper,
    UniversityT.Registrar
"%>

<%
  // Code that is in the "service()" method.

  UniversityHelper univHelper= new UniversityHelper();

  // Get the Course Number
  String courseNum = (String) request.getParameter("COURSE_NUM");

  // Get the Course details
  UniversityT.CourseDetails[] details=null;

  try {
    // Get a connection from the WLEC pool which has been initialized 
    // at the web server startup.
    univHelper.univInit();
    details = univHelper.get_course_details(courseNum);
  
    // Do the schedule stuff, start time, duration, days of the week
    int start_hours = details[0].class_schedule.start_hour;

    String start_time = new Integer(start_hours).toString() + ":00";
    int duration_hours = details[0].class_schedule.duration/60;
    int duration_minutes = 
      details[0].class_schedule.duration - (duration_hours * 60);

    String string_duration_minutes;
    if (duration_minutes == 0)
      string_duration_minutes = "00";
    else
      string_duration_minutes = new Integer(duration_minutes).toString();

    String duration_time = new Integer(duration_hours).toString() +
      ":" + string_duration_minutes;
  
    String days = null;
    if ((details[0].class_schedule.class_days & UniversityT.MONDAY.value) != 0)
      days = " mon";
    if ((details[0].class_schedule.class_days & UniversityT.TUESDAY.value) != 0)
      days = days + " tue";
    if ((details[0].class_schedule.class_days & UniversityT.WEDNESDAY.value) != 0)
      days = days + " wed";
    if ((details[0].class_schedule.class_days & UniversityT.THURSDAY.value) != 0)
      days = days + " thur";
    if ((details[0].class_schedule.class_days & UniversityT.FRIDAY.value) != 0)
      days = days + " fri";
  
%>

    <html><head><title>Display Course Details</title></head>
    <body><p><img src=images/BEA_Button_Final_web.gif align=right>
    <h5>Course Title: <%=details[0].title%></h5>
    <h5>Course Number: <%=courseNum%></h5>
    <h5>Professor: <%=details[0].professor%></h5>
    <h5>Course Description: <%=details[0].description%></h5>
    <h5>Cost: <%=details[0].cost%></h5>
    <h5>Number of Credits: <%=details[0].number_of_credits%></h5>
    <h5>Number of Seats: <%=details[0].number_of_seats%></h5>
    <h5>Class Schedule: Starts at <%=start_time%> duration: <%=duration_time%> on <%=days%></h5>
    <p>
    Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.

    </body></html>
<%
  }
  catch (Exception e)
  {
%>
    <html>
    <head><title>Display Course Details - Error</title></head>
    <body bgcolor=#FFFFFF>
    <p><img src=images/BEA_Button_Final_web.gif align=right>
    <font face="Helvetica">
        
    <center>
    <h3>
    <font color='#FF0000'>
    System Error: <%=e.toString()%>
    </font>
    </h3>

    <form>
    <input type='button' value='Back' OnClick='history.go(-1)'>
    </form>
    <p>
    Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.
        
    </center>
    </font>
    </body>
    </html>

<%
  }
%>
