<%
/*
 * Copyright (c) 1999-2001 BEA Systems, Inc.  All rights reserved
 *
 * THIS IS SOURCE CODE PUBLISHED FOR DEMONSTRATION PURPOSES
 *
 * This JSP file illustrates how an Internet client uses a servlet
 * to invoke operations on a BEA Tuxedo CORBA object.
 */
%>

<%@ page import="
    com.beasys.Tobj.*,
    com.beasys.*,
    UniversityT.RegistrarFactory,
    UniversityT.RegistrarFactoryHelper,
    UniversityT.Registrar 
"%>

<%!
org.omg.CosTransactions.Current TransCur;
boolean validId = true;
%>

<%
  // Code that is in the "service()" method.

  UniversityHelper univHelper= new UniversityHelper();

  // Get the Student Id and the Course Number
  String courseNum = (String) request.getParameter("COURSE_NUM");
  String studentId = (String) request.getParameter("STUDENT_ID");

  try {
    // Get a connection from the WLEC connection pool which has been initialized 
    // at the web server startup.
    univHelper.univInit();
    TransCur = univHelper.getTransCur();
    validId = univHelper.verifyStudent(studentId);
  }
  catch(Exception e)
  {
%>
    <html>
    <head><title>Register For Course - Error</title></head>
    <body bgcolor=#FFFFFF>
    <p><img src=images/BEA_Button_Final_web.gif align=right>
    <font face="Helvetica">
    <center>
    <h3> <font color='#FF0000'>
    Unexpected Error: <%=e.toString()%>
    </font> </h3>

    <form>
    <input type='button' value='Back' OnClick='history.go(-1)'>
    </form>
    <p>
    Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.
    
    </center>
    </font>
    </body>
    </html>
<%
    return;
  }

  if (validId == false)
  {
%>

    <html>
    <head><title>Register For Course - Application Error</title></head>
    <body bgcolor=#FFFFFF>
    <p><img src=images/BEA_Button_Final_web.gif align=right>
    <font face="Helvetica">

    <center>
    <h3>
    <font color='#FF0000'>
    Application Error
    </font>
    </h3>
    
    <table border=0>
    <tr>
    <td align=right><b>Student Id</b></td>
    <td><font color='#0000FF'>
    <%=
      request.getParameter("STUDENT_ID")
    %>
    </font></td>
    </tr>
    </table>

    <form>
    <input type='button' value='Back' OnClick='history.go(-1)'>
    </form>
    <p>
    Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.
    
    </center>
    </font>
    </body>
    </html>

<%
    return;
  }
  int studentIden = Integer.parseInt (studentId);
  UniversityT.NotRegistered[] notRegistered = null;
  boolean status = false;
      
  int[] selectedCourses = new int[1];
  selectedCourses[0] = Integer.parseInt(courseNum);

  try {
    TransCur.begin();
    // Invoke the operation on the Register object to register for the course
    notRegistered = univHelper.gRegistrarObjRef.register_for_courses(
                        studentIden,
                        selectedCourses);    
    boolean preventCommit = false;
  
    if (notRegistered != null)
    {
      if (notRegistered.length > 0 )
      {
        for (int i = 0 ; i < notRegistered.length; i++)
        {
%>
          <html>
          <head><title>Register For Course - Application Error</title></head>
          <body bgcolor=#FFFFFF>
	  <p><img src=images/BEA_Button_Final_web.gif align=right>
          <font face="Helvetica">

          <center>
          <h4>
          <font color='#FF0000'>
          Application Error: Either you are already registered for the course or an invalid course # was entered. This transaction will be rolled back
          </font>
          </h4>
          
          <form>
          <input type='button' value='Back' OnClick='history.go(-1)'>
          </form>
          <p>
          Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.
    
          </center>
          </font>
          </body>
          </html>
<%
        }
        preventCommit = true;
      }        
    }
    
    if (!preventCommit)
    {
      boolean reportHeuristics = true;
      TransCur.commit(reportHeuristics);
      status = true;
%>
      <html><head><title>Register For Course </title></head>
      <body bgcolor=#FFFFFF>
      <p><img src=images/BEA_Button_Final_web.gif align=right>
      <font face="Helvetica">
      <center>
      <h><b>Registration Successful </b></h>
      <form>
      <input type='button' value='Back' OnClick='history.go(-1)'>
      </form>
      <p>
      Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.
    
      </center>
      </body></html>
<%
    }
    else
    {
      TransCur.rollback();
      try { Thread.sleep(3 * 1000); } // 3 seconds 
      catch (InterruptedException e) {}
      status = false;
    }    
    return;
  }
  catch(UniversityT.TooManyCredits e)
  {
%>
          <html>
          <head><title>Register For Course - Error</title></head>
          <body bgcolor=#FFFFFF>
          <p><img src=images/BEA_Button_Final_web.gif align=right>
          <font face="Helvetica">
          <center>
          <h4> <font color='#FF0000'>
          Application Error: Too Many credits: Cannot have more than <%=e.maximum_credits%>. This transaction will be rolled back
          </font> </h4>
<%
    try
    {
        TransCur.rollback();
    }
    catch(org.omg.CosTransactions.NoTransaction nte)
    {
%>
      <html>
      <head><title>Register For Course - Error</title></head>
      <body bgcolor=#FFFFFF>
      <p><img src=images/BEA_Button_Final_web.gif align=right>
      <font face="Helvetica">
      <center>
      <h3> <font color='#FF0000'>
      System Error: No Transaction: <%=nte.toString()%>
      </font> </h3>
<%
    }
  }
  catch(org.omg.CosTransactions.NoTransaction nte)
  {
%>
    <html>
    <head><title>Register For Course - Error</title></head>
    <body bgcolor=#FFFFFF>
    <p><img src=images/BEA_Button_Final_web.gif align=right>
    <font face="Helvetica">
    <center>
    <h3> <font color='#FF0000'>
    System Error: No Transaction: <%=nte.toString()%>
    </font> </h3>
<%
  }
  catch(org.omg.CosTransactions.SubtransactionsUnavailable e)
  {  
%>
    <html>
    <head><title>Register For Course - Error</title></head>
    <body bgcolor=#FFFFFF>
    <p><img src=images/BEA_Button_Final_web.gif align=right>
    <font face="Helvetica">
    <center>
    <h3> <font color='#FF0000'>
    System Error: Subtransactions Unavailable: <%=e.toString()%>
    </font> </h3>
<%
  }
  catch(org.omg.CosTransactions.HeuristicHazard e)
  {
%>
    <html>
    <head><title>Register For Course - Error</title></head>
    <body bgcolor=#FFFFFF>
    <p><img src=images/BEA_Button_Final_web.gif align=right>
    <font face="Helvetica">
    <center>
    <h3> <font color='#FF0000'>
    System Error: HeuristicHazard: <%=e.toString()%>
    </font> </h3>
<%
  }
  catch(org.omg.CosTransactions.HeuristicMixed e)
  {
%>
    <html>
    <head><title>Register For Course - Error</title></head>
    <body bgcolor=#FFFFFF>
    <p><img src=images/BEA_Button_Final_web.gif align=right>
    <font face="Helvetica">
    <center>
    <h3> <font color='#FF0000'>
    System Error: HeuristicMixed: <%=e.toString()%>
    </font> </h3>
<%
  }
%>
  <form>
  <input type='button' value='Back' OnClick='history.go(-1)'>
  </form>
  <p>
  Copyright (c) 1999-2000 by BEA Systems, Inc. All Rights Reserved.
  
  </center>
  </font>
  </body>
  </html>

