package examples.wtc.atmi.convsimp;

import javax.ejb.*;
import java.rmi.RemoteException;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;

/**
 * The methods in this interface are the public face of the simpapp client.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject, ToupperBeanE, implements this interface and
 * delegates to the bean.
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface TuxedoConversation extends EJBObject {

  /**
   * This implements a conversation back and forth to a Tuxedo conversational
   * service.  The conversation does two send and receive loops, starting with
   * a send loop (unless there is only one iteration, since the first data gets
   * sent in the tpconnect call).  After the conversation has finished, the
   * method returns.<p>
   * This method uses TypedCArray data to send, and checks that the output
   * data from tprecv matches the input data sent by tpsend.
   * @param datasize The amount of data to send to the remote conversation
   * @param iterations The number of tpsend/tprecvs to do
   * @throws TPException if something bad happens during the course of the
   * conversation
   */
  public void conversation(int datasize, int iterations) 
          throws TPException, RemoteException;
}

