package examples.wtc.atmi.convsimp;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;
import weblogic.wtc.jatmi.TypedCArray;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.jatmi.Conversation;
import weblogic.wtc.jatmi.ApplicationToMonitorInterface;


import weblogic.wtc.gwt.TuxedoConnectionFactory;
import weblogic.wtc.gwt.TuxedoConnection;

/**
 * ToupperBean is a stateful SessionBean. This EJBean illustrates:
 * <ul>
 * <li> The use of the Tuxedo Oatmial connector
 * <li> The use of Application-defined exceptions
 * </ul>
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class TuxedoConversationBean implements SessionBean {

  static final boolean VERBOSE = true;

  private SessionContext ctx;

  /**
   * Sets the session context.
   * 
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");

    this.ctx = ctx;
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbActivate() {
    log("ejbActivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbRemove() {
    log("ejbRemove called");
  } 

  /**
   * This method corresponds to the create method in the home interface
   * "ToupperHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ToupperHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   * 
   * @exception               javax.ejb.CreateException
   * if there is a problem creating the bean
   */
  public void ejbCreate() throws CreateException {
    log("ejbCreate called");
  } 

  /**
   * This is the classic TOUPPER simpapp method, which takes the string
   * argument, and converts it to all upper case.  This implementation
   * will get the TuxedoConnectionFactory from JNDI, and use it to get
   * a Tuxedo object, which can then be used to do the actual tpcall.  Of
   * course, we must first convert the java String object to the TypedBuffer
   * TypedString object.
   * @param toConvert A string to be converted (not null)
   * @return the above string, converted to upper case
   */
  public void conversation(int datasize, int iterations) throws TPException {
    Context ctx;
    TuxedoConnectionFactory tcf;
    TuxedoConnection myTux;  // For now we get it via NEW until the Factory works
    TypedCArray myData = null;
    TypedCArray returnData = null;
    Reply myRtn = null;
    int status;
    int flags;
    int lcv;
    Conversation myConversation;
    int num_sends;
    int outstanding;

    log("conversation called, datasize:" + datasize + " iterations: " 
        + iterations);

    if (iterations <= 0) {
      return;
    } 

    try {
      ctx = new InitialContext();
      tcf = 
        (TuxedoConnectionFactory) ctx.lookup("tuxedo.services.TuxedoConnection");
    } catch (NamingException ne) {

      // Could not get the tuxedo object, throw TPENOENT
      throw new TPException(TPException.TPENOENT, 
                            "Could not get TuxedoConnectionFactory : " + ne);
    } 

    myTux = tcf.getTuxedoConnection();

    if (datasize > 0) {
      myData = new TypedCArray(datasize);

      for (lcv = 0; lcv < datasize; lcv++) {
        myData.carray[lcv] = (byte) (lcv & 0xff);
      } 
    } 

    num_sends = iterations;

    if (iterations <= 1) {
      flags = ApplicationToMonitorInterface.TPRECVONLY;
    } else {
      flags = ApplicationToMonitorInterface.TPSENDONLY;
    } 

    log("About to start convesation");

    try {
      myConversation = myTux.tpconnect("CTOUPPER", myData, flags);
      num_sends--;
    } catch (TPException te) {
      log("tpconnect threw TPException " + te);

      throw te;
    } catch (Exception ee) {
      log("tpconnect threw exception: " + ee);

      throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
    } 

    log("tpconnect successfull!");

    while (num_sends > 0) {
      if (num_sends <= 1) {
        flags = ApplicationToMonitorInterface.TPRECVONLY;
      } else {
        flags = 0;
      } 

      try {
        myConversation.tpsend(myData, flags);
      } catch (TPException te) {
        log("tpsend threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        log("tpsend threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 

      num_sends--;
    } 

    log("first send successful!");

    outstanding = iterations;

    while (outstanding > 0) {
      try {
        myRtn = myConversation.tprecv(0);

        if (outstanding <= 1) {
          log("tprecv did not get a SENDONLY when expected");

          throw new TPException(TPException.TPESYSTEM, 
                                "Did not get expected SENDONLY event");
        } 
      } catch (TPReplyException tre) {
        switch (tre.gettperrno()) {

          case TPException.TPEEVENT:
            switch (tre.getrevent()) {

              case TPException.TPEV_SENDONLY:
                if (outstanding > 1) {
                  log("tprecv got an SENDONLY before its time: " + tre);

                  throw new TPException(TPException.TPESYSTEM, 
                                        "Unexpected SENDONLY event: " + tre);
                } 

                myRtn = tre.getExceptionReply();

                break;

              default:

                // Anything else in this recv loop is an error
                log("tprecv got an unexpected event from the server: " + tre);

                throw new TPException(TPException.TPESYSTEM, 
                                      "Unexpected tprecv event: " + tre);
            }

            break;

          default:
            log("tprecv got an unexpected error from the server: " + tre);

            throw new TPException(TPException.TPESYSTEM, 
                                  "Unexpected tprecv exception: " + tre);
        }
      } catch (TPException te) {
        log("tprecv(1) threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        log("tprecv(1) threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 

      returnData = (TypedCArray) myRtn.getReplyBuffer();

      if (returnData.sendSize != myData.sendSize) {
        log("Invalid return data size:" + returnData.sendSize + "/" 
            + myData.sendSize);

        throw new TPException(TPException.TPESYSTEM, 
                              "Invalid return data sizes");
      } 

      for (lcv = 0; lcv < returnData.sendSize; lcv++) {
        if (returnData.carray[lcv] != myData.carray[lcv]) {
          log("Invalid return data:" + lcv + "/" + returnData.carray[lcv] 
              + "/" + myData.carray[lcv]);

          throw new TPException(TPException.TPESYSTEM, "Invalid return data");
        } 
      } 

      outstanding--;
    } 

    log("first receive successful!");

    num_sends = iterations;

    while (num_sends > 0) {
      if (num_sends <= 1) {
        flags = ApplicationToMonitorInterface.TPRECVONLY;
      } else {
        flags = 0;
      } 

      try {
        myConversation.tpsend(myData, flags);
      } catch (TPException te) {
        log("tpsend(2) threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        log("tpsend(2) threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 

      num_sends--;
    } 

    log("second send successful!");

    outstanding = iterations;

    while (outstanding > 0) {
      try {
        myRtn = myConversation.tprecv(0);

        if (outstanding <= 1) {
          log("tprecv(2) did not get a SVCSUCC when expected");

          throw new TPException(TPException.TPESYSTEM, 
                                "Did not get expected SVCSUCC event");
        } 
      } catch (TPReplyException tre) {
        switch (tre.gettperrno()) {

          case TPException.TPEEVENT:
            switch (tre.getrevent()) {

              case TPException.TPEV_SVCSUCC:
                if (outstanding > 1) {
                  log("tprecv got an SVCSUCC before its time: " + tre);

                  throw new TPException(TPException.TPESYSTEM, 
                                        "Unexpected SVCSUCC event: " + tre);
                } 

                myRtn = tre.getExceptionReply();

                break;

              default:

                // Anything else in this recv loop is an error
                log("tprecv(2) got an unexpected event from the server: " 
                    + tre);

                throw new TPException(TPException.TPESYSTEM, 
                                      "Unexpected tprecv event: " + tre);
            }

            break;

          default:
            log("tprecv(2) got an unexpected error from the server: " + tre);

            throw new TPException(TPException.TPESYSTEM, 
                                  "Unexpected tprecv exception: " + tre);
        }
      } catch (TPException te) {
        log("tprecv(2) threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        log("tprecv(2) threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 

      returnData = (TypedCArray) myRtn.getReplyBuffer();

      if (returnData.sendSize != myData.sendSize) {
        log("Invalid return data size(2):" + returnData.sendSize + "/" 
            + myData.sendSize);

        throw new TPException(TPException.TPESYSTEM, 
                              "Invalid return data sizes");
      } 

      for (lcv = 0; lcv < returnData.sendSize; lcv++) {
        if (returnData.carray[lcv] != myData.carray[lcv]) {
          log("Invalid return data(2):" + lcv + "/" + returnData.carray[lcv] 
              + "/" + myData.carray[lcv]);

          throw new TPException(TPException.TPESYSTEM, "Invalid return data");
        } 
      } 

      outstanding--;
    } 

    log("second receive successful!");

    myTux.tpterm();  // Closing the association with Tuxedo

    return;
  } 

  private void log(String s) {
    if (VERBOSE) {
      System.out.println(s);
    } 
  } 

}





