/*	Copyright (c) 1990, 1991 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include <stdio.h>
#include <userlog.h>
#include "atmi.h"		/* TUXEDO  Header File */
#include <Uunix.h>


#if defined(__STDC__) || defined(__cplusplus)
main(int argc, char *argv[])
#else
main(argc, argv)
int argc;
char *argv[];
#endif

{

	char *sendbuf, *rcvbuf;
	long sendlen, rcvlen;
	int ret;
	int cd;
	long	the_len;
	long	revent;
	long	num_bytes = 10;
	long	tot_ops = 1;
	long	num_sends;
	long	outstanding;
	long	flags = 0;
	long	ssleeptime = 0;
	long	rsleeptime = 0;
	int	c;

	proc_name = "convcl";

	while ((c = getopt(argc, argv, "s:r:b:I:")) != EOF) {
		switch(c) {
		case 's':
			if ((ssleeptime = atol(optarg)) < 0) {
				ssleeptime = 0;
			}
			break;
		case 'r':
			if ((rsleeptime = atol(optarg)) < 0) {
				rsleeptime = 0;
			}
			break;
		case 'b':
			if ((num_bytes = atol(optarg)) < 1) {
				num_bytes = 10;
			}
			break;
		case 'I':
			if ((tot_ops = atol(optarg)) < 0) {
				tot_ops = 1;
			}
			break;
		default:
			(void) fprintf(stderr, "Usage: %s [-s send_sleep] [-r recv_sleep] [-b num_bytes] [-I iterations]\n", argv[0]);
			exit(1);
		}
	}

	/* Attach to System/T as a Client Process */
	if (tpinit((TPINIT *) NULL) == -1) {
		fprintf(stderr, "Tpinit failed tperrno=%d(%s)\n",
			tperrno, tpstrerror(tperrno));
		userlog("main(50) Tpinit failed tperrno=%d(%s)",
			tperrno, tpstrerror(tperrno));
		exit(1);
	}
	
	/* Allocate STRING buffers for the request and the reply */

	if((sendbuf = (char *) tpalloc("CARRAY", NULL, num_bytes)) == NULL) {
		fprintf(stderr,"Error allocating send buffer tperrno=%d(%s)",
			tperrno, tpstrerror(tperrno));
		userlog("main(60) Error allocating send buffer tperrno=%d(%s)",
			tperrno, tpstrerror(tperrno));
		tpterm();
		exit(1);
	}

	if((rcvbuf = (char *) tpalloc("CARRAY", NULL, num_bytes)) == NULL) {
		fprintf(stderr,"Error allocating receive buffer tperrno=%d(%s)\n",
			tperrno, tpstrerror(tperrno));
		userlog("main(70) Error allocating receive buffer tperrno=%d(%s)",
			tperrno, tpstrerror(tperrno));
		tpfree(sendbuf);
		tpterm();
		exit(1);
	}

	(void) memset(sendbuf, '\0', num_bytes);

	(void) strcpy(sendbuf, argv[1]);

	num_sends = tot_ops;
	if (num_sends <= 1) {
		flags = TPRECVONLY;
	}
	else {
		flags = TPSENDONLY;
	}

	if ((cd=tpconnect("CTOUPPER", sendbuf, num_bytes, flags)) == -1) {
		fprintf(stderr, "tpconnect fails.  tperrno=%d(%s)\n",
			tperrno, tpstrerror(tperrno));
		userlog("main(80) tpconnect fails.  tperrno=%d(%s)",
			tperrno, tpstrerror(tperrno));

		tpfree(sendbuf);
		tpfree(rcvbuf);
		tpterm();
		exit(1);
	}
	num_sends--;

	while (num_sends > 0) {
		if (num_sends <= 1) {
			flags = TPRECVONLY;
		}
		else {
			flags = 0;
		}

		if (tpsend(cd, sendbuf, num_bytes, flags, &revent) == -1) {
			fprintf(stderr, "tpsend error tperrno=%d(%s)\n",
				tperrno, tpstrerror(tperrno));
			userlog("main(90) tpsend error tperrno=%d(%s)",
				tperrno, tpstrerror(tperrno));
			if(tperrno == TPEEVENT) {
				fprintf(stderr, "revent=0x%lx\n", revent);
				userlog("main(100) revent=0x%lx", revent);
			}
			tpfree(sendbuf);
			tpfree(rcvbuf);
			tpterm();
			exit(1);
		}

		if (ssleeptime > 0) {
			printf("tpsend passed, iteration %ld, sleeping %ld seconds\n",
				tot_ops - num_sends, ssleeptime);
			sleep(ssleeptime);
		}
		num_sends--;
	}
	printf("First sends completed normally.  Starting recv loop\n");

	outstanding = tot_ops;
	while (outstanding > 0) {

		(void) memset(rcvbuf, 0xff, num_bytes);
		ret =tprecv(cd, (char **) &rcvbuf, &the_len, TPNOCHANGE, &revent);
		if (outstanding <= 1) {
			if (ret != -1) {
				fprintf(stderr, "tprecv does NOT get an event\n");
				userlog("main(110) tprecv does NOT get an event");
				tpfree(sendbuf);
				tpfree(rcvbuf);
				tpterm();
				exit(1);
			}

			if (tperrno != TPEEVENT) {
				fprintf(stderr, "tprecv got unexpected tperrno=%d(%s)\n", 
					tperrno, tpstrerror(tperrno));
				userlog("main(120) tprecv got unexpected tperrno=%d(%s)", 
					tperrno, tpstrerror(tperrno));
				tpfree(sendbuf);
				tpfree(rcvbuf);
				tpterm();
				exit(1);
			}

			if(revent != TPEV_SENDONLY) {
				fprintf(stderr, "tprecv does not get the send only event. revent=0x%lx\n",
					revent);
				userlog("main(130) tprecv does not get the send only event. revent=0x%lx",
					revent);
				tpfree(sendbuf);
				tpfree(rcvbuf);
				tpterm();
				exit(1);
			}
		}
		else if (ret == -1) {
			fprintf(stderr, "tprecv unexpected tperrno=%d(%s) or event 0x%lx\n", 
				tperrno, tpstrerror(tperrno), revent);
			userlog("main(140) tprecv unexpected tperrno=%d(%s) or event 0x%lx", 
				tperrno, tpstrerror(tperrno), revent);
			tpfree(sendbuf);
			tpfree(rcvbuf);
			tpterm();
			exit(1);
		}

		if ((the_len != num_bytes) ||
			(memcmp(sendbuf, rcvbuf, num_bytes) != 0)) {
			fprintf(stderr, "invalid return buffer\n");
			userlog("main(150) invalid return buffer");
			tpfree(sendbuf);
			tpfree(rcvbuf);
			tpterm();
			exit(1);
		}
		outstanding--;
		printf("Returned buffer OK iteration %ld\n",
			tot_ops - outstanding);
		if (rsleeptime > 0) {
			sleep(rsleeptime);
		}
	}

	num_sends = tot_ops;
	while (num_sends > 0) {
		if (num_sends <= 1) {
			flags = TPRECVONLY;
		}
		else {
			flags = 0;
		}

		if (tpsend(cd, sendbuf, num_bytes, flags, &revent) == -1) {
			fprintf(stderr, "tpsend gets an tperrno=%d(%s)\n",
				tperrno, tpstrerror(tperrno));
			userlog("main(160) tpsend gets an tperrno=%d(%s)",
				tperrno, tpstrerror(tperrno));
			if(tperrno == TPEEVENT) {
				fprintf(stderr, "revent=0x%lx\n", revent);
				userlog("main(170) revent=0x%lx", revent);
			}
			tpfree(sendbuf);
			tpfree(rcvbuf);
			tpterm();
			exit(1);
		}

		if (ssleeptime > 0) {
			printf("tpsend passed, iteration %ld, sleeping %ld seconds\n",
				tot_ops - num_sends, ssleeptime);
			sleep(ssleeptime);
		}
		num_sends--;
	}
	printf("Second sends completed normally.  Starting recv loop\n");

	outstanding = tot_ops;
	while (outstanding > 0) {

		(void) memset(rcvbuf, 0xff, num_bytes);
		ret =tprecv(cd, (char **) &rcvbuf, &the_len, TPNOCHANGE, &revent);
		if (outstanding <= 1) {
			if (ret != -1) {
				fprintf(stderr, "tprecv does NOT get an event\n");
				userlog("main(180) tprecv does NOT get an event");
				tpfree(sendbuf);
				tpfree(rcvbuf);
				tpterm();
				exit(1);
			}

			if (tperrno != TPEEVENT) {
				fprintf(stderr, "tprecv got unexpected tperrno=%d(%s)\n", 
					tperrno, tpstrerror(tperrno));
				userlog("main(190) tprecv got unexpected tperrno=%d(%s)", 
					tperrno, tpstrerror(tperrno));
				tpfree(sendbuf);
				tpfree(rcvbuf);
				tpterm();
				exit(1);
			}

			if(revent != TPEV_SVCSUCC) {
				fprintf(stderr, "tprecv does not get the svcsucc event. revent=0x%lx\n",
					revent);
				userlog("main(200) tprecv does not get the svcsucc event. revent=0x%lx",
					revent);
				tpfree(sendbuf);
				tpfree(rcvbuf);
				tpterm();
				exit(1);
			}
		}
		else if (ret == -1) {
			fprintf(stderr, "tprecv unexpected tperrno=%d(%s)\n", 
				tperrno, tpstrerror(tperrno));
			userlog("main(210) tprecv unexpected tperrno=%d(%s) revent=0x%lx", 
				tperrno, tpstrerror(tperrno), revent);
			tpfree(sendbuf);
			tpfree(rcvbuf);
			tpterm();
			exit(1);
		}

		if (memcmp(sendbuf, rcvbuf, num_bytes) != 0) {
			fprintf(stderr, "invalid return buffer\n");
			userlog("main(220) invalid return buffer");
			tpfree(sendbuf);
			tpfree(rcvbuf);
			tpterm();
			exit(1);
		}
		outstanding--;
		printf("Returned buffer OK iteration %ld\n",
			tot_ops - outstanding);
		if (rsleeptime > 0) {
			sleep(rsleeptime);
		}
	}

	/* Free Buffers & Detach from System/T */
	tpfree(sendbuf);
	tpfree(rcvbuf);
	tpterm();
	exit(0);
}
