/*	Copyright (c) 1990, 1991 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include <stdio.h>
#include <ctype.h>
#include <atmi.h>	/* TUXEDO Header File */
#include <userlog.h>	/* TUXEDO Header File */
#include <Uunix.h>


static long	ssleeptime;	/* send sleep time */
static long	rsleeptime;	/* recv sleep time */

/*
 * Sleep type:
 *
 * 0 (Default): Sleep after tprecv
 * 1 : Sleep after tpsend
 * 2 : Sleep after both
 */

#if defined(__STDC__) || defined(__cplusplus)
tpsvrinit(int argc, char *argv[])
#else
tpsvrinit(argc, argv)
int argc;
char **argv;
#endif
{
	int	c;

	while ((c = getopt(argc, argv, "s:r:")) != EOF) {
		switch(c) {
		case 's':
			if ((ssleeptime = atol(optarg)) < 0) {
				ssleeptime = 0;
			}
			break;
		case 'r':
			if ((rsleeptime = atol(optarg)) < 0) {
				rsleeptime = 0;
			}
			break;
		default:
			;
		}
	}

	userlog("tpsvrinit(10) Welcome to the conversational simple server");
	return(0);
}

#ifdef __cplusplus
extern "C"
#endif
void
#if defined(__STDC__) || defined(__cplusplus)
CTOUPPER(TPSVCINFO *rqst)
#else
CTOUPPER(rqst)
TPSVCINFO *rqst;
#endif
{

	long	revent;
	long	the_len;
	long	tot_ops = 1;
	long	outstanding;
	long	num_send;
	long	ret;
	long	flags;
	int	go_on;

	if (rqst->flags & TPSENDONLY) {
		goto send_loop;
	}

	go_on = 1;
	while(go_on == 1) {
		if (tprecv(rqst->cd, &rqst->data, &the_len,
			TPNOCHANGE, &revent) != -1) {
			tot_ops++;
			if (rsleeptime > 0) {
				sleep(rsleeptime);
			}
			continue;
		}

		if ((tperrno == TPEEVENT) && (revent == TPEV_SENDONLY)) {
			tot_ops++;
			go_on = 0;
			if (rsleeptime > 0) {
				sleep(rsleeptime);
			}
			continue;
		}

		userlog("CTOUPPER(10) invalid errno %d(%s) or event 0x%lx",
			tperrno, tpstrerror(tperrno), revent);
		tpreturn(TPFAIL, 1, rqst->data, rqst->len, 0);
	}

send_loop:
	for (num_send = tot_ops; num_send > 0; num_send--) {
		if (num_send <= 1) {
			flags = TPRECVONLY;
		}
		else {
			flags = 0;
		}

		if (tpsend(rqst->cd, rqst->data, rqst->len, flags, &revent) == -1) {
			(void) userlog("CTOUPPER(20) tpsend error");
			if(tperrno == TPEEVENT) {
				userlog("CTOUPPER(30) got event: 0x%lx", revent);
			}
			else {
				userlog("CTOUPPER(40) tperrno = %d (%s)",
					tperrno, tpstrerror(tperrno));
			}
			tpreturn(TPFAIL, 2, rqst->data, rqst->len, 0);
		}
		if (ssleeptime > 0) {
			sleep(ssleeptime);
		}
	}

	for (outstanding = tot_ops; outstanding > 0; outstanding--) {
		ret = tprecv(rqst->cd, &rqst->data, &the_len,
			TPNOCHANGE, &revent);

		if (outstanding <= 1) {
			if (ret == -1) {
				if ((tperrno == TPEEVENT) && (revent == TPEV_SENDONLY)) {
					/* Everything is ok, go to last send loop */
					continue;
				}
				userlog("CTOUPPER(50) invalid tprecv tperrno %d(%s) or event 0x%lx",
					tperrno, tpstrerror(tperrno), revent);
				tpreturn(TPFAIL, 3, rqst->data, rqst->len, 0);
			}
			else {
				userlog("CTOUPPER(60) Did NOT get expected event");
				tpreturn(TPFAIL, 4, rqst->data, rqst->len, 0);
			}
		}

		if (ret == -1) {
			userlog("CTOUPPER(70) tprecv tperrno %d(%s) or event 0x%lx",
				tperrno, tpstrerror(tperrno), revent);
			tpreturn(TPFAIL, 5, rqst->data, rqst->len, 0);
		}
		if (rsleeptime > 0) {
			sleep(rsleeptime);
		}
	}

	/* The -1 is because the final data is sent in tpreturn */
	for (num_send = tot_ops - 1; num_send > 0; num_send--) {
		if (tpsend(rqst->cd, rqst->data, rqst->len, 0, &revent) == -1) {
			(void) userlog("CTOUPPER(80) tpsend error");
			if(tperrno == TPEEVENT) {
				userlog("CTOUPPER(90) got event: 0x%lx", revent);
			}
			else {
				userlog("CTOUPPER(100) tperrno = %d (%s)",
					tperrno, tpstrerror(tperrno));
			}
			tpreturn(TPFAIL, 6, rqst->data, rqst->len, 0);
		}
		if (ssleeptime > 0) {
			sleep(ssleeptime);
		}
	}

	tpreturn(TPSUCCESS, 0, rqst->data, rqst->len, 0);
}
