package examples.wtc.atmi.qsample;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TypedString;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.jatmi.DequeueReply;
import weblogic.wtc.jatmi.EnqueueRequest;

import weblogic.wtc.gwt.TuxedoConnectionFactory;
import weblogic.wtc.gwt.TuxedoConnection;

/**
 * QsampleBean is a stateful SessionBean. This EJBean illustrates:
 * <ul>
 * <li> The use of the Tuxedo Oatmial connector
 * <li> The use of Application-defined exceptions
 * </ul>
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class QsampleBean implements SessionBean {

  static final boolean VERBOSE = true;

  private SessionContext ctx;

  /**
   * Sets the session context.
   * 
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");

    this.ctx = ctx;
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbActivate() {
    log("ejbActivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbRemove() {
    log("ejbRemove called");
  } 

  /**
   * This method corresponds to the create method in the home interface
   * "QsampleHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>QsampleHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   * 
   * @exception               javax.ejb.CreateException
   * if there is a problem creating the bean
   */
  public void ejbCreate() throws CreateException {
    log("ejbCreate called");
  } 

  /**
   * This is the classic STRING qsample method, which takes the string
   * argument, and converts it to all upper case.  This implementation
   * will get the TuxedoConnectionFactory from JNDI, and use it to get
   * a Tuxedo object, which can then be used to do the actual tpcall.  Of
   * course, we must first convert the java String object to the TypedBuffer
   * TypedString object.
   * @param toConvert A string to be converted (not null)
   * @return the above string, converted to upper case
   */
  public String qtoupper(String toConvert) throws TPException {
    Context ctx;
    TuxedoConnectionFactory tcf;
    TuxedoConnection myTux;  // For now we get it via NEW until the Factory works
    TypedString myData;
    DequeueReply myRtn;
    int status;
    EnqueueRequest er;

    log("toupper called, converting " + toConvert);

    try {
      ctx = new InitialContext();
      tcf = 
        (TuxedoConnectionFactory) ctx.lookup("tuxedo.services.TuxedoConnection");
    } catch (NamingException ne) {

      // Could not get the tuxedo object, throw TPENOENT
      throw new TPException(TPException.TPENOENT, 
                            "Could not get TuxedoConnectionFactory : " + ne);
    } 

    myTux = tcf.getTuxedoConnection();

    myData = new TypedString(toConvert);

    log("About to call tpenqueue");

    try {
      er = new EnqueueRequest();

      er.setreplyqueue("RPLYQ");

      myTux.tpenqueue("QSPACE", "STRING", er, myData, 0);
      log("tpenqueue success, now waiting for dequeue");

      myRtn = myTux.tpdequeue("QSPACE", "RPLYQ", null, null, true, false, 0);
    } catch (TPException te) {
      log("tperrno thrown: " + te);

      throw te;
    } catch (Exception ee) {
      log("Tuxedo API threw exception: " + ee);

      throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
    } 

    log("Enqueue/Dequeue successfull!");

    myData = (TypedString) myRtn.getReplyBuffer();

    myTux.tpterm();  // Closing the association with Tuxedo

    return (myData.toString());
  } 

  private void log(String s) {
    if (VERBOSE) {
      System.out.println(s);
    } 
  } 

}

