package examples.wtc.atmi.simpFML32;

/*
 * Copyright (c) 2000 BEA Systems, Inc.
 * All rights reserved
 * 
 * THIS IS UNPUBLISHED PROPRIETARY
 * SOURCE CODE OF BEA Systems, Inc.
 * The copyright notice above does not
 * evidence any actual or intended
 * publication of such source code.
 */

import javax.ejb.*;
import java.rmi.RemoteException;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;

/**
 * The methods in this interface are the public face of the simpapp client.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject, RstrintBeanE, implements this interface and
 * delegates to the bean.
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2000 by BEA Systems, Inc. All Rights Reserved.
 */
public interface Rstring extends EJBObject {

  /**
   * This is the classic REVERSE_STRING simpapp method, which takes the string
   * argument, and converts it to all upper case.  However, rather than
   * simply convert it here, this method will invoke the EJB, which will
   * instead ship the processing request to a Tuxedo server, which will
   * perform the actual work.  Notice that all of the input and output
   * parameters are pure java types.  The actual conversion of these types
   * to TypedBuffers are done by the writer of the RstringBean.
   * @param toConvert A string to be converted (not null)
   * @return the above string, converted to upper case
   */
  public String Rstring(String toConvert) 
          throws TPException, TPReplyException, RemoteException;
}

