package examples.wtc.atmi.simpFML32;

/*
 * Copyright (c) 2000 BEA Systems, Inc.
 * All rights reserved
 * 
 * THIS IS UNPUBLISHED PROPRIETARY
 * SOURCE CODE OF BEA Systems, Inc.
 * The copyright notice above does not
 * evidence any actual or intended
 * publication of such source code.
 */

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;
import weblogic.wtc.jatmi.TypedFML32;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.gwt.TuxedoConnectionFactory;
import weblogic.wtc.gwt.TuxedoConnection;
import weblogic.wtc.jatmi.Ferror;

import examples.wtc.atmi.simpFML32.MyFieldTable;

/**
 * RstringBean is a stateful SessionBean. This EJBean illustrates:
 * <ul>
 * <li> The use of the Tuxedo Oatmial connector
 * <li> The use of Application-defined exceptions
 * </ul>
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2000 by BEA Systems, Inc. All Rights Reserved.
 */
public class RstringBean implements SessionBean {

  static final boolean VERBOSE = true;

  private SessionContext ctx;

  /**
   * Sets the session context.
   * 
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");

    this.ctx = ctx;
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbActivate() {
    log("ejbActivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbRemove() {
    log("ejbRemove called");
  } 

  /**
   * This method corresponds to the create method in the home interface
   * "RstringHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>RstringHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   * 
   * @exception               javax.ejb.CreateException
   * if there is a problem creating the bean
   */
  public void ejbCreate() throws CreateException {
    log("ejbCreate called");
  } 

  /**
   * This is the classic RSTRING simpapp method, which takes the string
   * argument, and converts it to all upper case.  This implementation
   * will get the TuxedoConnectionFactory from JNDI, and use it to get
   * a Tuxedo object, which can then be used to do the actual tpcall.  Of
   * course, we must first convert the java String object to the TypedBuffer
   * TypedFML32 object.
   * @param toConvert A string to be converted (not null)
   * @return the above string, converted to upper case
   */
  public String Rstring(String toConvert) 
          throws TPException, TPReplyException {
    Context ctx;
    TuxedoConnectionFactory tcf;
    TuxedoConnection myTux;  // For now we get it via NEW until the Factory works
    TypedFML32 myData;
    TypedFML32 myDataBack;
    Reply myRtn;
    int status;
    String myNewString = null;

    log("Reverse_String called, converting " + toConvert);

    try {
      ctx = new InitialContext();
      tcf = 
        (TuxedoConnectionFactory) ctx.lookup("tuxedo.services.TuxedoConnection");
    } catch (NamingException ne) {

      // Could not get the tuxedo object, throw TPENOENT
      throw new TPException(TPException.TPENOENT, 
                            "Could not get TuxedoConnectionFactory : " + ne);
    } 

    myTux = tcf.getTuxedoConnection();

    myData = new TypedFML32(new MyFieldTable());

    try {
      myData.Fchg(MyFieldTable.MyString, 0, toConvert);
    } catch (Ferror fe) {
      log("An error occured putting data into the FML32 buffer.  The error is " 
          + fe);
    } 

    log("About to call tpcall REVERSE_STRING");

    try {
      myRtn = myTux.tpcall("REVERSE_STRING", myData, 0);
    } catch (TPReplyException tre) {
      log("tpcall threw TPReplyExcption " + tre);

      throw tre;
    } catch (TPException te) {
      log("tpcall threw TPException " + te);

      throw te;
    } catch (Exception ee) {
      log("tpcall threw exception: " + ee);

      throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
    } 

    log("tpcall successfull!");

    myDataBack = (TypedFML32) myRtn.getReplyBuffer();

    try {
      myNewString = (String) myDataBack.Fget(MyFieldTable.MyString, 0);
    } catch (Ferror fe) {
      log("An error occured getting data from the FML32 buffer.  The error is " 
          + fe);
    } 

    myTux.tpterm();  // Closing the association with Tuxedo

    return (myNewString);
  } 

  private void log(String s) {
    if (VERBOSE) {
      System.out.println(s);
    } 
  } 

}





