#include <stdio.h>
#include <ctype.h>
#include <atmi.h>
#include <userlog.h>
#include <fml32.h>

#define	STRING	((FLDID32)167772417)	/* number: 257	 type: string */

void strrev(char * buffer)
{
   char new[512];
   char *ptr=NULL;
   char *newptr=new;
   int len;
   len = strlen(buffer);
   memset ( new, '\0', 512*sizeof(char) );
   userlog ("\noriginal string=%s", buffer);
   ptr = &buffer[len];
   while ( *ptr == '\0' )
   ptr--;
   while (*ptr)
   {
      *newptr++=*ptr;
         ptr--;
   }
   *newptr='\0';
   strcpy(buffer,new);
   userlog ("\nreversed buffer=%s\n\n", buffer);
}

#if defined(__STDC__) || defined(__cplusplus)
tpsvrinit(int argc, char *argv[])
#else
tpsvrinit(argc, argv)
int argc;
char **argv;
#endif
{
  argc = argc;
  argv = argv;
  userlog("Starting the simple FML32 REVERSE_STRING server");
  return(0);
}

#ifdef __cplusplus
extern "C"
#endif
void
#if defined(__STDC__) || defined(__cplusplus)
REVERSE_STRING(TPSVCINFO *rqst)
#else
REVERSE_STRING(rqst)
TPSVCINFO *rqst;
#endif
{

  int rc, eval, rval;
  char buffer[256], BufType[32], SubType[32];
  rval = TPSUCCESS; 
  eval = 0;
  memset(BufType, 0, sizeof(BufType));
  memset(SubType, 0, sizeof(SubType));
  rc = tptypes(rqst->data, BufType, SubType);
  if(rc < 0) {
    eval = 1;
    userlog("ERROR: tptypes() call");
  }
  else { 
	if(0 != strcmp(BufType, "FML32")) {
      eval = 2;
      userlog("ERROR: request buffer NOT type FML32!");
    }
    else { 
      eval = revstr((FBFR32 *)rqst->data);
    }
  }
  if(eval != 0) { 
    rval = TPFAIL;
  }
  tpreturn(rval, eval, rqst->data, rqst->len, 0);
}

int revstr(FBFR32 * fbfr)
{
  int rc, eval = 0;
  long length;
  char * buffer;
  length = Flen32(fbfr, STRING, 0);
  if(length < 0) {
    eval = 3;
    userlog("ERROR: REVERSE_STRING - STRING not found in FML buffer");
  }
  else { 
	buffer = (char *) malloc(1 + (size_t)length);
    if(buffer == NULL) {
      eval = 4;
      userlog("ERROR: REVERSE_STRING - Unable to malloc temporary space");
    }
    else { 
	  memset(buffer, 0, 1 + (size_t)length);
      rc = Fget32(fbfr, STRING, 0, buffer, (FLDLEN32 *)&length);
      if(rc < 0) {
        eval = 5;
        userlog("ERROR: REVERSE_STRING - Fget32() call");
      }
      else { 
		strrev(buffer);  /* finally do the actual work */
        rc = Fchg32(fbfr, STRING, 0, buffer, (FLDLEN32)length);
        if(rc < 0) {
          eval = 6;
          userlog("ERROR: REVERSE_STRING - Fchg32() call");
        }
	    userlog("REVERSE_STRING: %s", buffer);
      }
    }
    if(buffer != NULL) free(buffer);
  }
  return eval;
}