package examples.wtc.atmi.simpapp;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;
import weblogic.wtc.jatmi.TypedString;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.gwt.TuxedoConnectionFactory;
import weblogic.wtc.gwt.TuxedoConnection;

/**
 * ToupperBean is a stateful SessionBean. This EJBean illustrates:
 * <ul>
 * <li> The use of the Tuxedo Oatmial connector
 * <li> The use of Application-defined exceptions
 * </ul>
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class ToupperBean implements SessionBean {

  static final boolean VERBOSE = true;

  private SessionContext ctx;

  /**
   * Sets the session context.
   * 
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");

    this.ctx = ctx;
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbActivate() {
    log("ejbActivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbRemove() {
    log("ejbRemove called");
  } 

  /**
   * This method corresponds to the create method in the home interface
   * "ToupperHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ToupperHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   * 
   * @exception               javax.ejb.CreateException
   * if there is a problem creating the bean
   */
  public void ejbCreate() throws CreateException {
    log("ejbCreate called");
  } 

  /**
   * This is the classic TOUPPER simpapp method, which takes the string
   * argument, and converts it to all upper case.  This implementation
   * will get the TuxedoConnectionFactory from JNDI, and use it to get
   * a Tuxedo object, which can then be used to do the actual tpcall.  Of
   * course, we must first convert the java String object to the TypedBuffer
   * TypedString object.
   * @param toConvert A string to be converted (not null)
   * @return the above string, converted to upper case
   */
  public String Toupper(String toConvert) 
          throws TPException, TPReplyException {
    Context ctx;
    TuxedoConnectionFactory tcf;
    TuxedoConnection myTux;  // For now we get it via NEW until the Factory works
    TypedString myData;
    Reply myRtn;
    int status;

    log("toupper called, converting " + toConvert);

    try {
      ctx = new InitialContext();
      tcf = 
        (TuxedoConnectionFactory) ctx.lookup("tuxedo.services.TuxedoConnection");
    } catch (NamingException ne) {

      // Could not get the tuxedo object, throw TPENOENT
      throw new TPException(TPException.TPENOENT, 
                            "Could not get TuxedoConnectionFactory : " + ne);
    } 

    myTux = tcf.getTuxedoConnection();

    myData = new TypedString(toConvert);

    log("About to call tpcall");

    try {
      myRtn = myTux.tpcall("TOUPPER", myData, 0);
    } catch (TPReplyException tre) {
      log("tpcall threw TPReplyExcption " + tre);

      throw tre;
    } catch (TPException te) {
      log("tpcall threw TPException " + te);

      throw te;
    } catch (Exception ee) {
      log("tpcall threw exception: " + ee);

      throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
    } 

    log("tpcall successfull!");

    myData = (TypedString) myRtn.getReplyBuffer();

    myTux.tpterm();  // Closing the association with Tuxedo

    return (myData.toString());
  } 

  private void log(String s) {
    if (VERBOSE) {
      System.out.println(s);
    } 
  } 

}





