package examples.wtc.atmi.simpconv;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TPReplyException;
import weblogic.wtc.jatmi.TypedCArray;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.jatmi.Conversation;
import weblogic.wtc.jatmi.ApplicationToMonitorInterface;
import weblogic.wtc.jatmi.TPServiceInformation;


import weblogic.wtc.gwt.TuxedoConnectionFactory;
import weblogic.wtc.gwt.TuxedoConnection;

/**
 * ToupperBean is a stateful SessionBean. This EJBean illustrates:
 * <ul>
 * <li> The use of the Tuxedo Oatmial connector
 * <li> The use of Application-defined exceptions
 * </ul>
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class TuxedoServerConversationBean implements SessionBean {

  static final boolean VERBOSE = true;

  private SessionContext ctx;

  /**
   * Sets the session context.
   * 
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("setSessionContext called");

    this.ctx = ctx;
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbActivate() {
    log("ejbActivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbPassivate() {
    log("ejbPassivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbRemove() {
    log("ejbRemove called");
  } 

  /**
   * This method corresponds to the create method in the home interface
   * "ToupperHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ToupperHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   * 
   * @exception               javax.ejb.CreateException
   * if there is a problem creating the bean
   */
  public void ejbCreate() throws CreateException {
    log("ejbCreate called");
  } 

  /**
   * This is the classic TOUPPER simpapp method, which takes the string
   * argument, and converts it to all upper case.  This implementation
   * will get the TuxedoConnectionFactory from JNDI, and use it to get
   * a Tuxedo object, which can then be used to do the actual tpcall.  Of
   * course, we must first convert the java String object to the TypedBuffer
   * TypedString object.
   * @param toConvert A string to be converted (not null)
   * @return the above string, converted to upper case
   */
  public Reply service(TPServiceInformation mydata) throws TPException {
    TypedCArray returnData = null;
    int flags;
    int tot_ops = 1;
    boolean go_on;
    int num_send;
    int outstanding;
    Reply myRtn = null;

    log("server conversation called.  Service " + mydata.getServiceName());

    returnData = (TypedCArray) mydata.getServiceData();
    flags = mydata.getServiceFlags();

    if ((flags & ApplicationToMonitorInterface.TPCONV) == 0) {
      log("Invalid server flags " + flags);

      throw new TPException(TPException.TPEINVAL, 
                            "ERROR: Conversational ejb called in non-conversational context");
    } 

    if ((flags & ApplicationToMonitorInterface.TPSENDONLY) != 0) {
      go_on = false;
    } else {
      go_on = true;
    } 

    while (go_on) {
      try {
        myRtn = mydata.tprecv(0);
      } catch (TPReplyException tre) {
        switch (tre.gettperrno()) {

          case TPException.TPEEVENT:
            switch (tre.getrevent()) {

              case TPException.TPEV_SENDONLY:
                myRtn = tre.getExceptionReply();
                go_on = false;

                break;

              default:

                // Anything else in this recv loop is an error
                mydata.tpdiscon();
                log("tprecv got an unexpected event from the server: " + tre);

                throw new TPException(TPException.TPESYSTEM, 
                                      "Unexpected tprecv event: " + tre);
            }

            break;

          default:
            log("tprecv got an unexpected error from the server: " + tre);

            throw new TPException(TPException.TPESYSTEM, 
                                  "Unexpected tprecv exception: " + tre);
        }
      } catch (TPException te) {
        mydata.tpdiscon();
        log("tprecv(1) threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        mydata.tpdiscon();
        log("tprecv(1) threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 

      returnData = (TypedCArray) myRtn.getReplyBuffer();

      tot_ops++;
    } 

    log("first receives complete, iterations:" + tot_ops);

    for (num_send = tot_ops; num_send > 0; num_send--) {
      if (num_send <= 1) {
        flags = ApplicationToMonitorInterface.TPRECVONLY;
      } else {
        flags = 0;
      } 

      try {
        mydata.tpsend(returnData, flags);
      } catch (TPException te) {
        mydata.tpdiscon();
        log("tpsend threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        mydata.tpdiscon();
        log("tpsend threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 
    } 

    log("first sends successfull!");

    for (outstanding = tot_ops; outstanding > 0; outstanding--) {
      try {
        myRtn = mydata.tprecv(0);

        if (outstanding <= 1) {
          mydata.tpdiscon();
          log("tprecv(2) did not get a SENDONLY when expected");

          throw new TPException(TPException.TPESYSTEM, 
                                "Did not get expected SENDONLY event");
        } 
      } catch (TPReplyException tre) {
        switch (tre.gettperrno()) {

          case TPException.TPEEVENT:
            switch (tre.getrevent()) {

              case TPException.TPEV_SENDONLY:
                if (outstanding > 1) {
                  mydata.tpdiscon();
                  log("tprecv(2) got an SENDONLY before its time: " + tre);

                  throw new TPException(TPException.TPESYSTEM, 
                                        "Unexpected SENDONLY event: " + tre);
                } 

                myRtn = tre.getExceptionReply();

                break;

              default:

                // Anything else in this recv loop is an error
                mydata.tpdiscon();
                log("tprecv(2) got an unexpected event from the server: " 
                    + tre);

                throw new TPException(TPException.TPESYSTEM, 
                                      "Unexpected tprecv event: " + tre);
            }

            break;

          default:
            mydata.tpdiscon();
            log("tprecv(2) got an unexpected error from the server: " + tre);

            throw new TPException(TPException.TPESYSTEM, 
                                  "Unexpected tprecv exception: " + tre);
        }
      } catch (TPException te) {
        mydata.tpdiscon();
        log("tprecv(2) threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        mydata.tpdiscon();
        log("tprecv(2) threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 

      returnData = (TypedCArray) myRtn.getReplyBuffer();
    } 

    log("second recieves successfull!");

    flags = 0;

    for (num_send = tot_ops - 1; num_send > 0; num_send--) {
      try {
        mydata.tpsend(returnData, flags);
      } catch (TPException te) {
        mydata.tpdiscon();
        log("tpsend(2) threw TPException " + te);

        throw te;
      } catch (Exception ee) {
        mydata.tpdiscon();
        log("tpsend(2) threw exception: " + ee);

        throw new TPException(TPException.TPESYSTEM, "Exception: " + ee);
      } 
    } 

    log("second sends successfull!");

    mydata.setReplyBuffer(returnData);

    return (mydata);
  } 

  private void log(String s) {
    if (VERBOSE) {
      System.out.println(s);
    } 
  } 

}





