package examples.wtc.atmi.simpserv;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.TypedString;
import weblogic.wtc.jatmi.Reply;
import weblogic.wtc.jatmi.TPServiceInformation;

/**
 * ToupperBean is a stateful SessionBean. This EJBean illustrates:
 * <ul>
 * <li> The use of the Tuxedo Oatmial connector
 * <li> The use of Application-defined exceptions
 * </ul>
 * 
 * @author Copyright (c) 1998 by WebLogic, Inc. All Rights Reserved.
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class TolowerBean implements SessionBean {

  static final boolean VERBOSE = true;

  private SessionContext ctx;

  /**
   * Sets the session context.
   * 
   * @param ctx               SessionContext Context for session
   */
  public void setSessionContext(SessionContext ctx) {
    log("Tolower setSessionContext called");

    this.ctx = ctx;
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbActivate() {
    log("Tolower ejbActivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbPassivate() {
    log("Tolower ejbPassivate called");
  } 

  /**
   * This method is required by the EJB Specification,
   * but is not used by this example.
   * 
   */
  public void ejbRemove() {
    log("Tolower ejbRemove called");
  } 

  /**
   * This method corresponds to the create method in the home interface
   * "ToupperHome.java".
   * The parameter sets of the two methods are identical. When the client calls
   * <code>ToupperHome.create()</code>, the container allocates an instance of
   * the EJBean and calls <code>ejbCreate()</code>.
   * 
   * @exception               javax.ejb.CreateException
   * if there is a problem creating the bean
   */
  public void ejbCreate() throws CreateException {
    log("toLower ejbCreate called");
  } 

  /**
   * This is the classic TOUPPER simpapp method, which takes the string
   * argument, and converts it to all upper case.  This implementation
   * will get the TuxedoConnectionFactory from JNDI, and use it to get
   * a Tuxedo object, which can then be used to do the actual tpcall.  Of
   * course, we must first convert the java String object to the TypedBuffer
   * STRING object.
   * @param toConvert A string to be converted (not null)
   * @return the above string, converted to upper case
   */
  public Reply service(TPServiceInformation mydata) throws TPException {
    TypedString data;
    String lowered;
    TypedString return_data;

    log("service tolower called");

    data = (TypedString) mydata.getServiceData();
    lowered = data.toString().toLowerCase();
    return_data = new TypedString(lowered);

    mydata.setReplyBuffer(return_data);

    return (mydata);
  } 

  private void log(String s) {
    if (VERBOSE) {
      System.out.println(s);
    } 
  } 

}

