package examples.wtc.corba.simpappcns;

import javax.ejb.*;
import java.rmi.RemoteException;

/**
 * The methods in this interface are the public face of the simpapp client.
 * The signatures of the methods are identical to those of the EJBean, except
 * that these methods throw a java.rmi.RemoteException.
 * Note that the EJBean does not implement this interface. The corresponding
 * code-generated EJBObject, ToupperBeanE, implements this interface and
 * delegates to the bean.
 *
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public interface
ToupperCorba
	extends EJBObject
{

/**
 * This is the classic TOUPPER simpapp method, which takes the string
 * argument, and converts it to all upper case.  However, rather than
 * simply convert it here, this method will invoke the EJB, which will
 * instead ship the processing request to a Tuxedo CORBA server, which will
 * perform the actual work.  
 * @param toConvert A string to be converted (not null)
 * @return the above string, converted to upper case
 */
public String Toupper(String toConvert)
    throws RemoteException;
}
