package examples.wtc.corba.simpappcns;

import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.rmi.RemoteException;
import org.omg.CORBA.ORB;
import SimpleFactory;
import SimpleFactoryHelper;
import Simple;
import SimpleHelper;


/**
 * ToupperCorbaBean is a stateful SessionBean. This EJBean illustrates:
 * <ul>
 * <li> The use of the WTC
 * </ul>
 *
 * @author Copyright (c) 1998-2001 by BEA Systems, Inc. All Rights Reserved.
 */
public class
ToupperCorbaBean
	implements SessionBean
{

  static final boolean VERBOSE = true;

  private SessionContext ctx;

/**
 * Sets the session context.
 *
 * @param ctx               SessionContext Context for session
 */
public void
setSessionContext(SessionContext ctx)
{
	log("setSessionContext called");
	this.ctx = ctx;
}

/**
 * This method is required by the EJB Specification,
 * but is not used by this example.
 *
 */
public void
ejbActivate()
{
	log("ejbActivate called");
}

/**
 * This method is required by the EJB Specification,
 * but is not used by this example.
 *
 */
public void
ejbPassivate()
{
	log("ejbPassivate called");
}

/**
 * This method is required by the EJB Specification,
 * but is not used by this example.
 *
 */
public void
ejbRemove()
{
	log("ejbRemove called");
}

/**
 * This method corresponds to the create method in the home interface
 * "ToupperHome.java".
 * The parameter sets of the two methods are identical. When the client calls
 * <code>ToupperHome.create()</code>, the container allocates an instance of 
 * the EJBean and calls <code>ejbCreate()</code>.
 *
 * @exception               javax.ejb.CreateException
 *                          if there is a problem creating the bean
 */
public void
ejbCreate()
	throws CreateException
{
	log("ejbCreate called");
}

/**
 * This is the classic TOUPPER simpapp method, which takes the string
 * argument, and converts it to all upper case.  This implementation
 * will get the TuxedoCorbaConnectionFactory from JNDI, and use it to get
 * a Tuxedo corba object, which can then be used to do the actual invoke.
 * @param toConvert A string to be converted (not null)
 * @return the above string, converted to upper case
 */
public String Toupper(String toConvert)
        throws RemoteException
{
	log("toupper called, converting " + toConvert);

        try {
            // Initialize the ORB.
            String args[] = null;
            Properties Prop;
            Prop = new Properties();
            Prop.put("org.omg.CORBA.ORBClass",
                     "weblogic.wtc.corba.ORB");

            ORB orb = ORB.init(args, Prop);

            // Get the simple factory.
            org.omg.CORBA.Object simple_fact_oref =
                orb.string_to_object("corbaname:tgiop:simpapp#simple_factory");

            // Narrow the simple factory.
            SimpleFactory simple_factory_ref =
                SimpleFactoryHelper.narrow(simple_fact_oref);
                
            // Find the simple object.
            Simple simple = simple_factory_ref.find_simple();
                
            // Convert the string to upper case.
            org.omg.CORBA.StringHolder buf = 
                new org.omg.CORBA.StringHolder(toConvert);
            simple.to_upper(buf);
            return buf.value;
        }
        catch (Exception e) {
            throw new RemoteException("Can't call TUXEDO CORBA server: " +e);
        }
}

private void
log(String s)
{
	if(VERBOSE) {
		System.out.println(s);
	}
}
}





