/*
 * Decompiled with CFR 0.152.
 */
package examples.ejb20.basic.statelessSession;

import examples.ejb20.basic.statelessSession.TradeResult;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TraderBean
implements SessionBean {
    private static final boolean VERBOSE = true;
    private SessionContext ctx;
    private int tradeLimit;

    public TradeResult buy(String string, int n) {
        if (n > this.tradeLimit) {
            this.log("Attempt to buy " + n + " is greater than limit of " + this.tradeLimit);
            n = this.tradeLimit;
        }
        this.log("Buying " + n + " shares of " + string);
        return new TradeResult(n, string);
    }

    public void ejbActivate() {
        this.log("ejbActivate called");
    }

    public void ejbCreate() throws CreateException {
        this.log("ejbCreate called");
        try {
            InitialContext initialContext = new InitialContext();
            Integer n = (Integer)initialContext.lookup("java:/comp/env/tradeLimit");
            this.tradeLimit = n;
        }
        catch (NamingException namingException) {
            throw new CreateException("Failed to find environment value " + namingException);
        }
    }

    public void ejbPassivate() {
        this.log("ejbPassivate called");
    }

    public void ejbRemove() {
        this.log("ejbRemove called");
    }

    private void log(String string) {
        System.out.println(string);
    }

    public TradeResult sell(String string, int n) {
        if (n > this.tradeLimit) {
            this.log("Attempt to sell " + n + " is greater than limit of " + this.tradeLimit);
            n = this.tradeLimit;
        }
        this.log("Selling " + n + " shares of " + string);
        return new TradeResult(n, string);
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.log("setSessionContext called");
        this.ctx = sessionContext;
    }
}

