/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.core;

import c8e.g.d;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class RmiJdbcDriver
implements Driver {
    public static final String RMI_PROTOCOL = "jdbc:cloudscape:rmi:";
    private static final String rjrmi_protocol = "jdbc:rmi:";
    private static final String cloudscapeDriver = "jdbc:cloudscape:";
    private static final String DOUBLE_SLASH = "//";
    private static final char SLASH = '/';
    private static final char COLON = ':';
    private static final String ILLEGAL_URL = d.getTextMessage("I019");
    private static final String ILLEGAL_HOST = d.getTextMessage("I020");
    private boolean active = false;

    public boolean acceptsURL(String string) {
        return this.active && string.startsWith(RMI_PROTOCOL);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        Connection connection = null;
        if (this.acceptsURL(string)) {
            connection = DriverManager.getConnection(this.translate(string), properties);
        }
        return connection;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return this.getRmiJdbcDriver().getPropertyInfo(this.translate(string), properties);
    }

    public int getMajorVersion() {
        int n2 = 1;
        try {
            n2 = this.getRmiJdbcDriver().getMajorVersion();
        }
        catch (SQLException sQLException) {}
        return n2;
    }

    public int getMinorVersion() {
        int n2 = 0;
        try {
            n2 = this.getRmiJdbcDriver().getMinorVersion();
        }
        catch (SQLException sQLException) {}
        return n2;
    }

    public boolean jdbcCompliant() {
        boolean bl = false;
        try {
            bl = this.getRmiJdbcDriver().jdbcCompliant();
        }
        catch (SQLException sQLException) {}
        return bl;
    }

    private String translate(String string) throws SQLException {
        String string2 = null;
        if (!this.acceptsURL(string)) {
            return string;
        }
        String string3 = string.substring(RMI_PROTOCOL.length());
        if (string3.startsWith(DOUBLE_SLASH)) {
            int n2 = string3.indexOf(47, 2);
            if (n2 <= 2) {
                throw new SQLException(String.valueOf(string3) + ILLEGAL_URL);
            }
            string2 = string3.substring(0, n2);
            string3 = string3.substring(n2 + 1);
            int n3 = string2.indexOf(58);
            if (n3 != -1) {
                if (string2.lastIndexOf(58) != n3) {
                    throw new SQLException(String.valueOf(string2) + ILLEGAL_HOST);
                }
                try {
                    int n4 = Integer.parseInt(string2.substring(n3 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException(String.valueOf(string2) + ILLEGAL_HOST);
                }
            }
            string2 = String.valueOf(string2) + '/';
        }
        String string4 = null;
        string4 = string2 != null ? rjrmi_protocol + string2 + cloudscapeDriver + string3 : "jdbc:rmi:jdbc:cloudscape:" + string3;
        return string4;
    }

    private Driver getRmiJdbcDriver() throws SQLException {
        return DriverManager.getDriver(rjrmi_protocol);
    }

    static {
        try {
            Driver driver;
            boolean bl = false;
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                driver = enumeration.nextElement();
                if (!(driver instanceof RmiJdbcDriver)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                Class.forName("RmiJdbc.RJDriver").newInstance();
                driver = new RmiJdbcDriver();
                DriverManager.registerDriver(driver);
                ((RmiJdbcDriver)driver).active = true;
            }
        }
        catch (Throwable throwable) {
            PrintStream printStream = DriverManager.getLogStream();
            if (printStream != null) {
                throwable.printStackTrace(printStream);
            }
            throwable.printStackTrace(System.out);
        }
    }
}

