/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.core;

import COM.cloudscape.core.AbstractDataSource;
import COM.cloudscape.core.BasicDataSource;
import COM.cloudscape.core.LocalConnectionPoolDataSource;
import c8e.g.d;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class DataSourceFactory
implements ObjectFactory {
    private static final String BASIC_DATASOURCE = "COM.cloudscape.core.BasicDataSource";
    private static final String CONNECTION_POOL_DATASOURCE = "COM.cloudscape.core.LocalConnectionPoolDataSource";
    private static final String XA_DATASOURCE = "COM.cloudscape.core.XaDataSource";
    private static final String ABSTRACT_DATASOURCE = "COM.cloudscape.core.AbstractDataSource";
    private static final String POOLED_CONNECTION = "c8e.p.c";
    private static final String XA_CONNECTION = "c8e.p.a";

    public static BasicDataSource getDataSource() {
        return new BasicDataSource();
    }

    public static LocalConnectionPoolDataSource getConnectionPoolDataSource() {
        return new LocalConnectionPoolDataSource();
    }

    public static XADataSource getXADataSource() throws Exception {
        try {
            return (XADataSource)Class.forName(XA_DATASOURCE).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(d.getTextMessage("I009"));
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        throw new SQLException(d.getTextMessage("I010"));
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        String string = reference.getClassName();
        AbstractDataSource abstractDataSource = null;
        if (string.equals(BASIC_DATASOURCE)) {
            abstractDataSource = new BasicDataSource();
        } else if (string.equals(CONNECTION_POOL_DATASOURCE)) {
            abstractDataSource = new LocalConnectionPoolDataSource();
        } else if (string.equals(XA_DATASOURCE)) {
            abstractDataSource = (AbstractDataSource)Class.forName(XA_DATASOURCE).newInstance();
        }
        if (abstractDataSource != null) {
            RefAddr refAddr = null;
            String string2 = null;
            refAddr = reference.get("databaseName");
            if (refAddr != null) {
                string2 = (String)refAddr.getContent();
            }
            if (refAddr == null || string2 == null) {
                return null;
            }
            abstractDataSource.setDatabaseName(string2);
            refAddr = reference.get("dataSourceName");
            if (refAddr != null && (string2 = (String)refAddr.getContent()) != null) {
                abstractDataSource.setDataSourceName(string2);
            }
            if ((refAddr = reference.get("description")) != null && (string2 = (String)refAddr.getContent()) != null) {
                abstractDataSource.setDescription(string2);
            }
            if ((refAddr = reference.get("createDatabase")) != null && (string2 = (String)refAddr.getContent()) != null && string2.equals("create")) {
                abstractDataSource.setCreateDatabase(string2);
            }
            if ((refAddr = reference.get("shutdownDatabase")) != null && (string2 = (String)refAddr.getContent()) != null && string2.equals("shutdown")) {
                abstractDataSource.setShutdownDatabase(string2);
            }
            if ((refAddr = reference.get("cloudscapeProperties")) != null && (string2 = (String)refAddr.getContent()) != null) {
                abstractDataSource.setCloudscapeProperties(string2);
            }
        }
        return abstractDataSource;
    }

    static PooledConnection getPooledConnection(LocalConnectionPoolDataSource localConnectionPoolDataSource) throws SQLException {
        try {
            Class<?> clazz = Class.forName(POOLED_CONNECTION);
            Class[] classArray = new Class[]{Class.forName(ABSTRACT_DATASOURCE)};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{localConnectionPoolDataSource};
            return (PooledConnection)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(d.getTextMessage("I011"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        throw new SQLException(d.getTextMessage("I012"));
    }

    static PooledConnection getPooledConnection(LocalConnectionPoolDataSource localConnectionPoolDataSource, String string, String string2) throws SQLException {
        try {
            Class<?> clazz = Class.forName(POOLED_CONNECTION);
            Class[] classArray = new Class[]{Class.forName(ABSTRACT_DATASOURCE), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{localConnectionPoolDataSource, string, string2};
            return (PooledConnection)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(d.getTextMessage("I011"));
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        throw new SQLException(d.getTextMessage("I012"));
    }

    static XAConnection getXAConnection(Object object, Object object2, Driver driver) throws SQLException {
        try {
            Class<?> clazz = Class.forName(XA_CONNECTION);
            Class[] classArray = new Class[]{Class.forName(ABSTRACT_DATASOURCE), Class.forName("c8e.c.c"), Class.forName("java.sql.Driver")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{object, object2, driver};
            return (XAConnection)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(d.getTextMessage("I011"));
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        throw new SQLException(d.getTextMessage("I012"));
    }

    static XAConnection getXAConnection(Object object, Object object2, Driver driver, String string, String string2) throws SQLException {
        try {
            Class<?> clazz = Class.forName(XA_CONNECTION);
            Class[] classArray = new Class[]{Class.forName(ABSTRACT_DATASOURCE), Class.forName("c8e.c.c"), Class.forName("java.sql.Driver"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{object, object2, driver, string, string2};
            return (XAConnection)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(d.getTextMessage("I013"));
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        throw new SQLException(d.getTextMessage("I014"));
    }
}

