/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.ui.tabbed;

import COM.cloudscape.ui.panel.JarFileEditPanel;
import COM.cloudscape.ui.panel.JarFileExecutePanel;
import COM.cloudscape.ui.panel.StatementsEditPanel;
import COM.cloudscape.ui.tabbed.TabbedEditPanel;
import c8e.ca._l;
import c8e.cc._a;
import c8e.cc.c;
import c8e.ch.l;
import c8e.ci.a;
import c8e.e.p_;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedJarFilePanel
extends TabbedEditPanel
implements _l {
    JarFileEditPanel jarFileEditPanel = new JarFileEditPanel();
    JarFileExecutePanel jarFileExecutePanel = new JarFileExecutePanel();
    StatementsEditPanel statementsEditPanel = new StatementsEditPanel();

    public TabbedJarFilePanel() {
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        super.jbInit();
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TabbedJarFilePanel.this.tabs_stateChanged(changeEvent);
            }
        });
    }

    public void postInit() {
        this.addTab(p_.getTextMessage("CV_JarFile_727"), this.jarFileEditPanel);
        this.addTab(p_.getTextMessage("CV_Exec_726"), this.jarFileExecutePanel);
        this.addTab(p_.getTextMessage("CV_Sql_724"), this.statementsEditPanel);
    }

    public c getJarFile() {
        return this.jarFileEditPanel.getJarFile();
    }

    public void setJarFile(c c2) {
        this.jarFileEditPanel.setJarFile(c2);
        this.jarFileExecutePanel.setJarFile(c2);
        this.statementsEditPanel.setDomain(c2);
        if (c2 != null) {
            this.getTabbedPane().setEnabledAt(1, c2.isSaved());
        }
    }

    public void setEdits(boolean bl2) {
        super.setEdits(bl2);
        this.jarFileEditPanel.setEdits(bl2);
    }

    public boolean hasEdits() {
        if (this.jarFileEditPanel.getJarFile().isDeleted()) {
            this.setEdits(false);
        }
        return this.edits;
    }

    public void cancel() {
        this.setEdits(false);
        if (this.getJarFile().isAdded()) {
            this.getJarFile().setStatusDeleted();
            this.getVisualDatabasePanel().deleteJarFileFromUI();
        } else {
            this.getJarFile().setPath(null);
            this.jarFileEditPanel.setJarFile(this.getJarFile());
        }
    }

    public boolean ok() {
        if (this.getJarFile().isDeleted()) {
            return true;
        }
        if (this.save()) {
            this.setEdits(false);
            this.statementsEditPanel.setDomain(this.getJarFile());
            return true;
        }
        this.setEdits(true);
        return false;
    }

    public boolean save() {
        return this.saveToDisk();
    }

    public boolean saveToDisk() {
        try {
            if (!this.jarFileEditPanel.saveFields()) {
                return true;
            }
            if (this.getJarFile().isAdded()) {
                this.getDomainConnection().saveJarFile(this.getJarFile());
                this.jarFileEditPanel.processClasspath();
            } else {
                this.getDomainConnection().replaceJarFile(this.getJarFile());
                this.jarFileEditPanel.processClasspath();
            }
            this.jarFileEditPanel.setInternal(true);
            this.setJarFile(this.getJarFile());
            return true;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == JarFileEditPanel.MISSING_NAME_EXCEPTION || string == JarFileEditPanel.MISSING_PATH_EXCEPTION) {
                JOptionPane.showMessageDialog(this.getVisualDatabasePanel(), string, p_.getTextMessage("CV_Clou_728"), 0);
            } else {
                new l(this.getFrame(), exception);
            }
            return false;
        }
    }

    public ImageIcon getToolBarIcon() {
        return a.getJarFileWithMenu(this);
    }

    public _a getToolBarDomain() {
        return this.getJarFile();
    }

    public void toolBarDelete() {
        this.deleteJarFile();
    }

    public void newJarFile() {
        this.getVisualDatabasePanel().newJarFile();
    }

    public void deleteJarFile() {
        this.getVisualDatabasePanel().deleteJarFile();
    }

    void tabs_stateChanged(ChangeEvent changeEvent) {
        block2: {
            Component component = this.getTabbedPane().getSelectedComponent();
            if (component instanceof JarFileEditPanel) break block2;
            try {
                this.jarFileEditPanel.saveFields();
            }
            catch (Exception exception) {}
        }
    }
}

