/*
 * Decompiled with CFR 0.152.
 */
package COM.cloudscape.util;

import COM.cloudscape.util.ColumnResultSet;
import c8e.bx.a;
import c8e.e.p_;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

public class JDBCDisplayUtil {
    private static final int MINWIDTH = 4;
    private static int maxWidth = 128;
    public static boolean showSelectCount;
    private static String FAILED_STATEMENT_HEADER;
    private static String FAILED_STATEMENT_BLANK;
    private static String FAILED_STATEMENT_BANNER;
    private static String FAILURE_FLAG;
    private static int FAILURE_FLAG_COLUMN;
    private static final int MAX_RETRIES = 0;

    private JDBCDisplayUtil() {
    }

    public static boolean init() {
        return p_.init();
    }

    public static boolean init(String string) {
        return JDBCDisplayUtil.init(string, null);
    }

    public static boolean init(String string, String string2) {
        return p_.init(string, string2);
    }

    public static void ShowException(PrintWriter printWriter, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printWriter);
        }
    }

    public static void ShowSQLException(PrintWriter printWriter, SQLException sQLException) {
        String string = Boolean.getBoolean("ij.showErrorCode") ? p_.getTextMessage("UT_Error0", p_.getNumberAsString(sQLException.getErrorCode())) : "";
        while (sQLException != null) {
            String string2 = JDBCDisplayUtil.mapNull(sQLException.getSQLState(), p_.getTextMessage("UT_NoSqlst"));
            String string3 = JDBCDisplayUtil.mapNull(sQLException.getMessage(), p_.getTextMessage("UT_NoMessa"));
            printWriter.println(p_.getTextMessage("UT_Error012", string2, string3, string));
            JDBCDisplayUtil.doTrace(printWriter, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            String string = JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), p_.getTextMessage("UT_NoSqlst_7"));
            String string2 = JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), p_.getTextMessage("UT_NoMessa_8"));
            printWriter.println(p_.getTextMessage("UT_Warni01", string, string2));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void DisplayResults(PrintWriter printWriter, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, statement, connection, 0, false);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, Statement statement, Connection connection, int n2, boolean bl2) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, n2, bl2);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printWriter, statement.getUpdateCount(), n2);
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, statement);
    }

    static void DisplayUpdateCount(PrintWriter printWriter, int n2, int n3) {
        if (n2 == 1) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n3, p_.getTextMessage("UT_1RowInserUpdatDelet"));
        } else if (n2 >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n3, p_.getTextMessage("UT_0RowsInserUpdatDelet", p_.getNumberAsString(n2)));
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n3, p_.getTextMessage("UT_StateExecu"));
        }
    }

    public static void DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, 0, false);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n2, boolean bl2) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = 0;
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        int n4 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n2);
        boolean bl3 = true;
        int n5 = 0;
        while (bl3) {
            try {
                bl3 = resultSet.next();
                if (!bl3) continue;
                if (bl2 && resultSet.getString(FAILURE_FLAG_COLUMN).equals(FAILURE_FLAG)) {
                    JDBCDisplayUtil.flagFailedStatement(printWriter, n2);
                }
                JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n4, vector, connection, n2);
                JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
                ++n3;
            }
            catch (SQLException sQLException) {
                if (++n5 > 0) {
                    throw sQLException;
                }
                JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
            }
        }
        if (showSelectCount) {
            if (n3 == 1) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n2, p_.getTextMessage("UT_1RowSelec"));
            } else if (n3 >= 0) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n2, p_.getTextMessage("UT_0RowsSelec", p_.getNumberAsString(n3)));
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n2);
        vector = null;
    }

    private static void flagFailedStatement(PrintWriter printWriter, int n2) {
        printWriter.println();
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, FAILED_STATEMENT_HEADER);
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, FAILED_STATEMENT_BLANK);
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, FAILED_STATEMENT_BANNER);
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, FAILED_STATEMENT_BLANK);
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, FAILED_STATEMENT_HEADER);
        printWriter.println();
    }

    private static void DisplayNestedResults(PrintWriter printWriter, Vector vector, Connection connection, int n2) throws SQLException {
        if (vector == null) {
            return;
        }
        String string = p_.getTextMessage("UT_JDBCDisplayUtil_16");
        String string2 = "0";
        int n3 = 0;
        while (n3 < vector.size()) {
            p_.out.println();
            String string3 = Integer.toString(n3);
            if (string3.length() > string2.length()) {
                string2 = string3;
                string = String.valueOf(string) + p_.getTextMessage("UT_JDBCDisplayUtil_17");
            }
            p_.out.println(string);
            p_.out.println(p_.getTextMessage("UT_Resul0", p_.getNumberAsString(n3)));
            p_.out.println(string);
            JDBCDisplayUtil.indent_DisplayResults(printWriter, (ResultSet)vector.elementAt(n3), connection, n2, false);
            ++n3;
        }
    }

    public static void DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printWriter, resultSet, connection, 0);
    }

    private static void indent_DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n2) throws SQLException {
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n3 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n2);
            JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n3, vector, connection, n2);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, p_.getTextMessage("UT_NoCurreRow"));
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n2);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printWriter, resultSet, connection, 0);
    }

    private static void indent_DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n2) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, p_.getTextMessage("UT_NoCurreRow_19"));
            return;
        }
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n2);
        JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n3, vector, connection, n2);
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n2);
        vector = null;
    }

    public static int DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, 0);
    }

    private static int indent_DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData, int n2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = n3 - 1;
        int n5 = 1;
        while (n5 <= n3) {
            n4 += Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n5) == 0 ? 0 : 4, p_.getColumnDisplaySize(resultSetMetaData, n5)));
            ++n5;
        }
        stringBuffer.ensureCapacity(n4);
        int n6 = 1;
        while (n6 <= n3) {
            if (n6 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n6);
            int n7 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n6) == 0 ? 0 : 4, p_.getColumnDisplaySize(resultSetMetaData, n6)));
            if (string.length() < n7) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n7);
                int n8 = stringBuffer2.length() + 64;
                while (n8 <= n7) {
                    stringBuffer2.append("                                                                ");
                    n8 += 64;
                }
                int n9 = stringBuffer2.length() + 16;
                while (n9 <= n7) {
                    stringBuffer2.append("                ");
                    n9 += 16;
                }
                int n10 = stringBuffer2.length() + 4;
                while (n10 <= n7) {
                    stringBuffer2.append("    ");
                    n10 += 4;
                }
                int n11 = stringBuffer2.length();
                while (n11 < n7) {
                    stringBuffer2.append(' ');
                    ++n11;
                }
                stringBuffer.append((Object)stringBuffer2);
            } else if (string.length() > n7) {
                if (n7 > 1) {
                    stringBuffer.append(string.substring(0, n7 - 1));
                }
                if (n7 > 0) {
                    stringBuffer.append('&');
                }
            } else {
                stringBuffer.append(string);
            }
            ++n6;
        }
        stringBuffer.setLength(Math.min(n4, 1024));
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, stringBuffer);
        int n12 = 0;
        while (n12 < Math.min(n4, 1024)) {
            stringBuffer.setCharAt(n12, '-');
            ++n12;
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, stringBuffer);
        stringBuffer = null;
        return n4;
    }

    private static void DisplayRow(PrintWriter printWriter, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n2, Vector vector, Connection connection, int n3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        int n4 = resultSetMetaData.getColumnCount();
        boolean bl2 = false;
        Vector<Object> vector2 = null;
        Vector<String> vector3 = null;
        int n5 = 1;
        while (n5 <= n4) {
            String string;
            if (n5 > 1) {
                stringBuffer.append('|');
            }
            if (resultSetMetaData.getColumnType(n5) != 1111) {
                string = p_.getLocalizedString(resultSet, resultSetMetaData, n5);
            } else {
                Object object = resultSet.getObject(n5);
                if (object == null) {
                    string = "NULL";
                } else if (object instanceof ColumnResultSet) {
                    string = resultSet.getString(n5);
                    bl2 = true;
                    if (vector2 == null) {
                        vector2 = new Vector<Object>();
                        vector3 = new Vector<String>();
                    }
                    vector2.addElement(object);
                    vector3.addElement(resultSetMetaData.getColumnName(n5));
                } else if (object instanceof ResultSet && vector != null) {
                    string = p_.getTextMessage("UT_Resul0_20", p_.getNumberAsString(vector.size()));
                    vector.addElement(object);
                } else {
                    try {
                        string = resultSet.getString(n5);
                    }
                    catch (SQLException sQLException) {
                        string = object.toString();
                    }
                }
            }
            if (string == null) {
                string = "NULL";
            }
            int n6 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n5) == 0 ? 0 : 4, p_.getColumnDisplaySize(resultSetMetaData, n5)));
            if (string.length() < n6) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n6);
                int n7 = string.length();
                while (n7 < n6) {
                    stringBuffer2.append(' ');
                    ++n7;
                }
                string = stringBuffer2.toString();
            } else if (string.length() > n6) {
                string = String.valueOf(string.substring(0, n6 - 1)) + "&";
            }
            stringBuffer.append(string);
            ++n5;
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n3, stringBuffer);
        if (bl2) {
            JDBCDisplayUtil.displayColumnResultSets(printWriter, n2, vector2, vector3, connection, n3);
        }
    }

    private static void displayColumnResultSets(PrintWriter printWriter, int n2, Vector vector, Vector vector2, Connection connection, int n3) throws SQLException {
        ++n3;
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ColumnResultSet columnResultSet = (ColumnResultSet)enumeration.nextElement();
            columnResultSet.setConnection(connection);
            boolean bl2 = columnResultSet.toString().equals("StatementListVTI");
            String string = (String)enumeration2.nextElement();
            printWriter.println();
            JDBCDisplayUtil.indentedPrintLine(printWriter, n3, p_.getTextMessage("UT_ConteOf0", string));
            printWriter.println();
            JDBCDisplayUtil.indent_DisplayResults(printWriter, (ResultSet)columnResultSet, connection, n3, bl2);
            printWriter.println();
        }
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw a.objectWasNull(string);
        }
    }

    public static String mapNull(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }

    public static void doTrace(PrintWriter printWriter, Exception exception) {
        if (Boolean.getBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    public static void setMaxDisplayWidth(int n2) {
        maxWidth = n2;
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n2, String string) {
        JDBCDisplayUtil.indent(printWriter, n2);
        printWriter.println(string);
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n2, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printWriter, n2);
        printWriter.println(stringBuffer);
    }

    private static void indent(PrintWriter printWriter, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            printWriter.print("  ");
            ++n3;
        }
    }

    public static void ShowException(PrintStream printStream, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printStream);
        }
    }

    public static void ShowSQLException(PrintStream printStream, SQLException sQLException) {
        String string = Boolean.getBoolean("ij.showErrorCode") ? " (errorCode = " + sQLException.getErrorCode() + ")" : "";
        while (sQLException != null) {
            printStream.println("ERROR " + JDBCDisplayUtil.mapNull(sQLException.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLException.getMessage(), "(no message)") + string);
            JDBCDisplayUtil.doTrace(printStream, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintStream printStream, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            printStream.println("WARNING " + JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), "(no message)"));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintStream printStream, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void DisplayResults(PrintStream printStream, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, statement, connection, 0, false);
    }

    private static void indent_DisplayResults(PrintStream printStream, Statement statement, Connection connection, int n2, boolean bl2) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, n2, bl2);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printStream, statement.getUpdateCount(), n2);
        }
        JDBCDisplayUtil.ShowWarnings(printStream, statement);
    }

    static void DisplayUpdateCount(PrintStream printStream, int n2, int n3) {
        if (n2 == 1) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n3, "1 row inserted/updated/deleted");
        } else if (n2 >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n3, String.valueOf(n2) + " rows inserted/updated/deleted");
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n3, "Statement executed.");
        }
    }

    public static void DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, 0, false);
    }

    private static void indent_DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection, int n2, boolean bl2) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = 0;
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        int n4 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n2);
        boolean bl3 = true;
        int n5 = 0;
        while (bl3) {
            try {
                bl3 = resultSet.next();
                if (!bl3) continue;
                if (bl2 && resultSet.getString(FAILURE_FLAG_COLUMN).equals(FAILURE_FLAG)) {
                    JDBCDisplayUtil.flagFailedStatement(printStream, n2);
                }
                JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n4, vector, connection, n2);
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
                ++n3;
            }
            catch (SQLException sQLException) {
                if (++n5 > 0) {
                    throw sQLException;
                }
                JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
            }
        }
        if (showSelectCount) {
            if (n3 == 1) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n2, "1 row selected");
            } else if (n3 >= 0) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n2, String.valueOf(n3) + " rows selected");
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n2);
        vector = null;
    }

    private static void flagFailedStatement(PrintStream printStream, int n2) {
        printStream.println();
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, FAILED_STATEMENT_HEADER);
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, FAILED_STATEMENT_BLANK);
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, FAILED_STATEMENT_BANNER);
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, FAILED_STATEMENT_BLANK);
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, FAILED_STATEMENT_HEADER);
        printStream.println();
    }

    private static void DisplayNestedResults(PrintStream printStream, Vector vector, Connection connection, int n2) throws SQLException {
        if (vector == null) {
            return;
        }
        String string = "+ ResultSet #";
        String string2 = "++++++++++++++++";
        String string3 = "0";
        int n3 = 0;
        while (n3 < vector.size()) {
            System.out.println();
            String string4 = Integer.toString(n3);
            if (string4.length() > string3.length()) {
                string3 = string4;
                string2 = String.valueOf(string2) + "+";
            }
            System.out.println(string2);
            System.out.println(String.valueOf(string) + n3 + " +");
            System.out.println(string2);
            JDBCDisplayUtil.indent_DisplayResults(printStream, (ResultSet)vector.elementAt(n3), connection, n2, false);
            ++n3;
        }
    }

    public static void DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printStream, resultSet, connection, 0);
    }

    private static void indent_DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n2) throws SQLException {
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n3 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n2);
            JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n3, vector, connection, n2);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, "No current row");
        }
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n2);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printStream, resultSet, connection, 0);
    }

    private static void indent_DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n2) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, "No current row");
            return;
        }
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n2);
        JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n3, vector, connection, n2);
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n2);
        vector = null;
    }

    public static int DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, 0);
    }

    private static int indent_DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData, int n2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = n3 - 1;
        int n5 = 1;
        while (n5 <= n3) {
            n4 += Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n5) == 0 ? 0 : 4, resultSetMetaData.getColumnDisplaySize(n5)));
            ++n5;
        }
        stringBuffer.ensureCapacity(n4);
        int n6 = 1;
        while (n6 <= n3) {
            if (n6 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n6);
            int n7 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n6) == 0 ? 0 : 4, resultSetMetaData.getColumnDisplaySize(n6)));
            if (string.length() < n7) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n7);
                int n8 = stringBuffer2.length() + 64;
                while (n8 <= n7) {
                    stringBuffer2.append("                                                                ");
                    n8 += 64;
                }
                int n9 = stringBuffer2.length() + 16;
                while (n9 <= n7) {
                    stringBuffer2.append("                ");
                    n9 += 16;
                }
                int n10 = stringBuffer2.length() + 4;
                while (n10 <= n7) {
                    stringBuffer2.append("    ");
                    n10 += 4;
                }
                int n11 = stringBuffer2.length();
                while (n11 < n7) {
                    stringBuffer2.append(' ');
                    ++n11;
                }
                stringBuffer.append((Object)stringBuffer2);
            } else if (string.length() > n7) {
                if (n7 > 1) {
                    stringBuffer.append(string.substring(0, n7 - 1));
                }
                if (n7 > 0) {
                    stringBuffer.append('&');
                }
            } else {
                stringBuffer.append(string);
            }
            ++n6;
        }
        stringBuffer.setLength(Math.min(n4, 1024));
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, stringBuffer);
        int n12 = 0;
        while (n12 < Math.min(n4, 1024)) {
            stringBuffer.setCharAt(n12, '-');
            ++n12;
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, stringBuffer);
        stringBuffer = null;
        return n4;
    }

    private static void DisplayRow(PrintStream printStream, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n2, Vector vector, Connection connection, int n3) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        int n4 = resultSetMetaData.getColumnCount();
        boolean bl2 = false;
        Vector<Object> vector2 = null;
        Vector<String> vector3 = null;
        int n5 = 1;
        while (n5 <= n4) {
            String string;
            if (n5 > 1) {
                stringBuffer.append('|');
            }
            if (resultSetMetaData.getColumnType(n5) != 1111) {
                string = resultSet.getString(n5);
            } else {
                Object object = resultSet.getObject(n5);
                if (object == null) {
                    string = "NULL";
                } else if (object instanceof ColumnResultSet) {
                    string = resultSet.getString(n5);
                    bl2 = true;
                    if (vector2 == null) {
                        vector2 = new Vector<Object>();
                        vector3 = new Vector<String>();
                    }
                    vector2.addElement(object);
                    vector3.addElement(resultSetMetaData.getColumnName(n5));
                } else if (object instanceof ResultSet && vector != null) {
                    string = "ResultSet #" + vector.size();
                    vector.addElement(object);
                } else {
                    try {
                        string = resultSet.getString(n5);
                    }
                    catch (SQLException sQLException) {
                        string = object.toString();
                    }
                }
            }
            if (string == null) {
                string = "NULL";
            }
            int n6 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n5) == 0 ? 0 : 4, resultSetMetaData.getColumnDisplaySize(n5)));
            if (string.length() < n6) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n6);
                int n7 = string.length();
                while (n7 < n6) {
                    stringBuffer2.append(' ');
                    ++n7;
                }
                string = stringBuffer2.toString();
            } else if (string.length() > n6) {
                string = String.valueOf(string.substring(0, n6 - 1)) + "&";
            }
            stringBuffer.append(string);
            ++n5;
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n3, stringBuffer);
        if (bl2) {
            JDBCDisplayUtil.displayColumnResultSets(printStream, n2, vector2, vector3, connection, n3);
        }
    }

    private static void displayColumnResultSets(PrintStream printStream, int n2, Vector vector, Vector vector2, Connection connection, int n3) throws SQLException {
        ++n3;
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ColumnResultSet columnResultSet = (ColumnResultSet)enumeration.nextElement();
            columnResultSet.setConnection(connection);
            boolean bl2 = columnResultSet.toString().equals("StatementListVTI");
            String string = (String)enumeration2.nextElement();
            printStream.println();
            JDBCDisplayUtil.indentedPrintLine(printStream, n3, "Contents of " + string + ":");
            printStream.println();
            JDBCDisplayUtil.indent_DisplayResults(printStream, (ResultSet)columnResultSet, connection, n3, bl2);
            printStream.println();
        }
    }

    public static void doTrace(PrintStream printStream, Exception exception) {
        if (Boolean.getBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printStream);
            printStream.flush();
        }
    }

    private static void indentedPrintLine(PrintStream printStream, int n2, String string) {
        JDBCDisplayUtil.indent(printStream, n2);
        printStream.println(string);
    }

    private static void indentedPrintLine(PrintStream printStream, int n2, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printStream, n2);
        printStream.println(stringBuffer);
    }

    private static void indent(PrintStream printStream, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            printStream.print("  ");
            ++n3;
        }
    }

    static {
        p_.init();
        FAILED_STATEMENT_HEADER = p_.getTextMessage("UT_JDBCDisplayUtil_0");
        FAILED_STATEMENT_BLANK = p_.getTextMessage("UT_JDBCDisplayUtil_1");
        FAILED_STATEMENT_BANNER = p_.getTextMessage("UT_FaileState");
        FAILURE_FLAG = "F";
        FAILURE_FLAG_COLUMN = 4;
    }
}

