/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dx.dataset;

import com.borland.dx.dataset.AggManager;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.DirectIndex;
import com.borland.dx.dataset.InternalRow;
import com.borland.dx.dataset.LoadCancel;
import com.borland.dx.dataset.MatrixData;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.RowVariant;
import com.borland.dx.dataset.SortDescriptor;
import com.borland.dx.dataset.StorageDataSet;
import com.borland.dx.dataset.Variant;
import java.util.Locale;

public abstract class IndexData
extends MatrixData {
    private String d;
    private String c;
    protected int indexUpdateCount;
    protected boolean resolvable = true;
    protected boolean saveOriginal;
    protected int indexesLength;
    protected DirectIndex[] indexes;
    private InternalRow a;
    protected DirectIndex deleteIndex;
    protected DirectIndex updateIndex;
    protected DirectIndex insertIndex;
    DataSet[] b;

    public IndexData getIndexData() {
        return this;
    }

    static final DataSet[] a(DataSet[] dataSetArray, DataSet dataSet) {
        int n2 = IndexData.b(dataSetArray, dataSet);
        if (n2 > -1) {
            if (dataSetArray.length == 1) {
                dataSetArray = null;
            } else {
                DataSet[] dataSetArray2 = new DataSet[dataSetArray.length - 1];
                System.arraycopy(dataSetArray, 0, dataSetArray2, 0, n2);
                if (n2 < dataSetArray2.length) {
                    System.arraycopy(dataSetArray, n2 + 1, dataSetArray2, n2, dataSetArray2.length - n2);
                }
                dataSetArray = dataSetArray2;
            }
        }
        return dataSetArray;
    }

    static final DataSet[] c(DataSet[] dataSetArray, DataSet dataSet) {
        if (IndexData.b(dataSetArray, dataSet) < 0) {
            DataSet[] dataSetArray2;
            if (dataSetArray == null) {
                dataSetArray2 = new DataSet[1];
            } else {
                dataSetArray2 = new DataSet[dataSetArray.length + 1];
                System.arraycopy(dataSetArray, 0, dataSetArray2, 0, dataSetArray.length);
            }
            dataSetArray2[dataSetArray2.length - 1] = dataSet;
            dataSetArray = dataSetArray2;
        }
        return dataSetArray;
    }

    static int b(DataSet[] dataSetArray, DataSet dataSet) {
        if (dataSetArray != null) {
            for (int i2 = 0; i2 < dataSetArray.length; ++i2) {
                if (dataSetArray[i2] != dataSet) continue;
                return i2;
            }
        }
        return -1;
    }

    public final void removeDataSet(DataSet dataSet) throws DataSetException {
        this.b = IndexData.a(this.b, dataSet);
    }

    public final void addDataSet(DataSet dataSet) throws DataSetException {
        this.b = IndexData.c(this.b, dataSet);
    }

    public MatrixData getData() {
        return this;
    }

    public void setCalcNames(String string, String string2) {
        this.c = string;
        this.d = string2;
    }

    public String getCalcAggFieldsName() {
        return this.d;
    }

    public String getCalcFieldsName() {
        return this.c;
    }

    public boolean isEmpty() throws DataSetException {
        return this.getRowCount() == 0;
    }

    public void notifyRecalc(StorageDataSet storageDataSet) throws DataSetException {
        this.c = this.a(storageDataSet.getCalcFieldsListener());
        this.d = this.a(storageDataSet.getCalcAggFieldsListener());
    }

    private final String a(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    public boolean needsRecalc(StorageDataSet storageDataSet) throws DataSetException {
        String string = this.a(storageDataSet.getCalcFieldsListener());
        if (string == null != (this.c == null)) {
            return true;
        }
        if (string != null && !string.equals(this.c)) {
            return true;
        }
        string = this.a(storageDataSet.getCalcAggFieldsListener());
        if (string == null != (this.d == null)) {
            return true;
        }
        return string != null && !string.equals(this.d);
    }

    public boolean isMemoryData() {
        return false;
    }

    public final int getUpdatedRowCount() throws DataSetException {
        this.openPersistentIndex(2);
        return this.updateIndex == null ? 0 : this.updateIndex.lastRow() + 1;
    }

    public final int getDeletedRowCount() throws DataSetException {
        this.openPersistentIndex(1);
        return this.deleteIndex == null ? 0 : this.deleteIndex.lastRow() + 1;
    }

    public final int getInsertedRowCount() throws DataSetException {
        this.openPersistentIndex(4);
        return this.insertIndex == null ? 0 : this.insertIndex.lastRow() + 1;
    }

    public final void setLoadCancel(StorageDataSet storageDataSet, LoadCancel loadCancel) {
        storageDataSet.a(loadCancel);
    }

    public void cancelOperation() {
    }

    public Object getDataMonitor() {
        return this;
    }

    public final void closeIndexes() throws DataSetException {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].close();
        }
        if (this.insertIndex != null) {
            this.insertIndex.close();
        }
        if (this.deleteIndex != null) {
            this.deleteIndex.close();
        }
        if (this.updateIndex != null) {
            this.updateIndex.close();
        }
    }

    public final void indexUpdate(long l2) throws DataSetException {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].updateStore(l2);
        }
    }

    public void getUpdatedRows(StorageDataSet storageDataSet, DataSetView dataSetView) throws DataSetException {
        dataSetView.setStorageDataSet(storageDataSet);
    }

    public void getDeletedRows(StorageDataSet storageDataSet, DataSetView dataSetView) throws DataSetException {
        dataSetView.setStorageDataSet(storageDataSet);
    }

    public void getInsertedRows(StorageDataSet storageDataSet, DataSetView dataSetView) throws DataSetException {
        this.openPersistentIndex(4);
        dataSetView.setStorageDataSet(storageDataSet);
    }

    public final void recalc(StorageDataSet storageDataSet, AggManager aggManager) throws DataSetException {
        DataSetView dataSetView = new DataSetView();
        dataSetView.setStorageDataSet(storageDataSet);
        dataSetView.open();
        while (dataSetView.inBounds()) {
            dataSetView.k();
            dataSetView.next();
        }
        dataSetView.post();
        dataSetView.close();
    }

    public final InternalRow getInternalReadRow(StorageDataSet storageDataSet) {
        if (this.a == null) {
            this.a = new InternalRow(storageDataSet, this);
        }
        return this.a;
    }

    public final void clearInternalReadRow() {
        this.a = null;
    }

    public final void markIndexesForUpdate(RowVariant[] rowVariantArray) throws DataSetException {
        this.indexUpdateCount = 0;
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            if (!this.indexes[i2].markForUpdate(rowVariantArray)) continue;
            ++this.indexUpdateCount;
        }
    }

    public final void indexDelete(long l2) throws DataSetException {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].deleteStore(l2);
        }
    }

    public final void indexAdd(long l2) throws DataSetException {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].addStore(l2);
        }
    }

    public final void resetPendingStatus(boolean bl2) throws DataSetException {
        if (this.updateIndex != null) {
            this.updateIndex.resetPending(bl2);
        }
        if (this.insertIndex != null) {
            this.insertIndex.resetPending(bl2);
        }
        if (this.deleteIndex != null) {
            this.deleteIndex.resetPendingDeletes(bl2);
        }
    }

    public final void resetPendingStatus(long l2, boolean bl2) throws DataSetException {
        int n2 = this.getStatus(l2);
        if ((n2 & 0x200) != 0) {
            if ((n2 & 1) != 0) {
                this.deleteIndex.resetPendingDelete(l2, bl2);
            }
            if ((n2 & 2) != 0) {
                this.updateIndex.resetPending(l2, bl2);
            }
            if ((n2 & 4) != 0) {
                this.insertIndex.resetPending(l2, bl2);
            }
        }
    }

    public final int saveRow(int n2) throws DataSetException {
        this.saveOriginal = false;
        if (this.updateIndex != null && (n2 & 6) == 0) {
            this.saveOriginal = true;
        }
        return n2;
    }

    public long replaceLoadedRow(long l2, ReadWriteRow readWriteRow, RowVariant[] rowVariantArray, int n2) throws DataSetException {
        if (l2 == (long)-1 || this.getStatus(l2) != 8) {
            return this.insertRow(readWriteRow, rowVariantArray, n2);
        }
        this.replaceStoreRow(l2, rowVariantArray, n2);
        return l2;
    }

    public final void updateRow(long l2, Variant[] variantArray, RowVariant[] rowVariantArray, Column[] columnArray) throws DataSetException {
        int n2 = rowVariantArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            rowVariantArray[i2].changed = !rowVariantArray[i2].equalsInstance(variantArray[i2]);
        }
        this.markIndexesForUpdate(rowVariantArray);
        this.updateStoreRow(l2, rowVariantArray, columnArray);
    }

    public final void emptyRow(long l2) throws DataSetException {
        this.emptyStoreRow(l2);
    }

    public final void deleteRow(long l2) throws DataSetException {
        if (this.resolvable) {
            int n2 = this.getStatus(l2);
            if ((n2 & 4) != 0) {
                this.emptyStoreRow(l2);
            } else {
                if ((n2 & 2) != 0) {
                    this.restoreStoreRow(l2);
                }
                this.deleteStoreRow(l2);
                if (this.deleteIndex != null) {
                    this.deleteIndex.addStore(l2);
                }
                this.indexDelete(l2);
            }
        } else {
            this.deleteStoreRow(l2);
            this.indexDelete(l2);
        }
    }

    public DirectIndex[] getIndices() {
        return this.indexes;
    }

    public final boolean indexExists(SortDescriptor sortDescriptor, RowFilterListener rowFilterListener) throws DataSetException {
        this.openPersistentIndexes();
        return this.findIndex(sortDescriptor, sortDescriptor.getLocale(), rowFilterListener, 14, 17) != null;
    }

    public final DirectIndex findIndex(SortDescriptor sortDescriptor, Locale locale, RowFilterListener rowFilterListener, int n2, int n3) {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            if (this.a(sortDescriptor, this.indexes[i2].getSort())) {
                return this.indexes[i2];
            }
            if (!this.a(sortDescriptor, this.indexes[i2].getSort(), locale) || this.indexes[i2].getVisibleMask() != n2 || this.indexes[i2].getInvisibleMask() != n3 || !this.indexes[i2].hasRowFilterListener(rowFilterListener)) continue;
            return this.indexes[i2];
        }
        return null;
    }

    private final boolean a(SortDescriptor sortDescriptor, SortDescriptor sortDescriptor2, Locale locale) {
        if (sortDescriptor == sortDescriptor2) {
            return true;
        }
        if (sortDescriptor == null || sortDescriptor2 == null) {
            return false;
        }
        return sortDescriptor.equals(sortDescriptor2, locale);
    }

    private final boolean a(SortDescriptor sortDescriptor, SortDescriptor sortDescriptor2) {
        if (sortDescriptor == null || sortDescriptor2 == null) {
            return false;
        }
        return sortDescriptor.a(sortDescriptor2);
    }

    public void freeFetchIndex() throws DataSetException {
    }

    public boolean dropIndex(SortDescriptor sortDescriptor, Locale locale, RowFilterListener rowFilterListener, int n2, int n3) throws DataSetException {
        DirectIndex directIndex = this.findIndex(sortDescriptor, locale, rowFilterListener, n2, n3);
        if (directIndex != null) {
            directIndex.dropIndex();
            for (int i2 = 0; i2 < this.indexesLength; ++i2) {
                if (this.indexes[i2] != directIndex) continue;
                directIndex.close();
                --this.indexesLength;
                if (this.indexesLength > i2) {
                    System.arraycopy(this.indexes, i2 + 1, this.indexes, i2, this.indexesLength - i2);
                }
                DirectIndex[] directIndexArray = new DirectIndex[this.indexesLength];
                System.arraycopy(this.indexes, 0, directIndexArray, 0, this.indexesLength);
                return true;
            }
        }
        return false;
    }

    public final void dropIndex(DataSet dataSet) throws DataSetException {
        this.dropIndex(dataSet.getSort(), dataSet.getStorageDataSet().getLocale(), dataSet.getRowFilterListener(), dataSet.a, dataSet.x);
    }

    public final void dropAllIndexes() throws DataSetException {
        for (int i2 = 0; i2 < this.indexesLength; ++i2) {
            this.indexes[i2].dropIndex();
        }
        this.indexesLength = 0;
        this.indexes = null;
    }

    public void addIndex(DirectIndex directIndex, int n2) {
        if (n2 == 2) {
            this.updateIndex = directIndex;
        } else if (n2 == 1) {
            this.deleteIndex = directIndex;
        } else if (n2 == 4) {
            this.insertIndex = directIndex;
        } else {
            int n3 = this.indexes == null ? 0 : this.indexesLength;
            DirectIndex[] directIndexArray = new DirectIndex[n3 + 1];
            if (n3 > 0) {
                System.arraycopy(this.indexes, 0, directIndexArray, 0, n3);
            }
            this.indexes = directIndexArray;
            this.indexes[n3] = directIndex;
            this.indexesLength = this.indexes.length;
        }
    }

    public void openPersistentIndex(int n2) throws DataSetException {
    }

    public boolean openPersistentIndexes() throws DataSetException {
        return false;
    }

    public final DirectIndex openIndex(StorageDataSet storageDataSet, SortDescriptor sortDescriptor, RowFilterListener rowFilterListener, int n2, int n3) throws DataSetException {
        if (n2 == 2 && this.updateIndex != null) {
            return this.updateIndex;
        }
        if (n2 == 1 && this.deleteIndex != null) {
            return this.deleteIndex;
        }
        if (n2 == 4 && this.insertIndex != null) {
            return this.insertIndex;
        }
        DirectIndex directIndex = this.findIndex(sortDescriptor, storageDataSet.getLocale(), rowFilterListener, n2, n3);
        if (directIndex == null && this.openPersistentIndexes()) {
            directIndex = this.findIndex(sortDescriptor, storageDataSet.getLocale(), rowFilterListener, n2, n3);
        }
        if (directIndex == null) {
            if (sortDescriptor != null && sortDescriptor.isUnique() && storageDataSet.getDuplicates() != null) {
                DataSetException.deleteDuplicates();
            }
            DataRow dataRow = null;
            RowVariant[] rowVariantArray = null;
            if (rowFilterListener != null && !this.isMemoryData()) {
                dataRow = new DataRow(storageDataSet);
                rowVariantArray = dataRow.b(storageDataSet.j());
            }
            if ((directIndex = this.createIndex(storageDataSet, sortDescriptor, rowFilterListener, dataRow, rowVariantArray, n2, n3)).isMaintained()) {
                this.addIndex(directIndex, n2);
            }
        }
        return directIndex;
    }

    public final DirectIndex openIndex(DataSet dataSet) throws DataSetException {
        RowFilterListener rowFilterListener = dataSet.getRowFilterListener();
        DirectIndex directIndex = this.openIndex(dataSet.getStorageDataSet(), dataSet.getSort(), rowFilterListener, dataSet.a, dataSet.x);
        return directIndex;
    }

    public boolean canCalc() {
        return true;
    }

    public void replaceStoreRow(long l2, RowVariant[] rowVariantArray, int n2) throws DataSetException {
        DataSetException.w();
    }

    public void restoreStoreRow(long l2) throws DataSetException {
    }

    public void commitRestructure(StorageDataSet storageDataSet) throws DataSetException {
    }

    public void prepareRestructure(StorageDataSet storageDataSet) throws DataSetException {
    }

    public abstract DirectIndex createIndex(StorageDataSet var1, SortDescriptor var2, RowFilterListener var3, DataRow var4, RowVariant[] var5, int var6, int var7) throws DataSetException;

    public abstract void emptyStoreRow(long var1) throws DataSetException;

    public abstract void deleteStoreRow(long var1) throws DataSetException;
}

