/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.AspectPicker;
import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.control.GroupBox;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.ShapeControl;
import com.borland.jbcl.control.SplitPanel;
import com.borland.jbcl.layout.PaneConstraints;
import com.objectspace.jgl.HashMap;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;

public class ColorChooserPanel
extends BevelPanel
implements Serializable,
ItemListener,
KeyListener,
AdjustmentListener {
    private AspectPicker[] pickers;
    private Choice choice;
    private String[] text;
    private boolean changed = false;
    private boolean hsbMode = false;
    private int[] comp;
    private String[] hsbLabels;
    private String[] rgbLabels;
    private Checkbox[] checkbox;
    private ShapeControl sample = new ShapeControl(1);
    private Color value;
    static HashMap localizedTextToValueMap;
    static HashMap textToValueMap;
    static final Color[] colorValues;
    public static final String[][] colorNames;
    public static final String CUSTOM_TAG;

    static {
        CUSTOM_TAG = Res.getString(44);
        colorNames = new String[][]{{Res.getString(218), Res.getString(219), Res.getString(220), Res.getString(221), Res.getString(222), Res.getString(223), Res.getString(224), Res.getString(225), Res.getString(226), Res.getString(227), Res.getString(228), Res.getString(229), Res.getString(230), Res.getString(231), Res.getString(232), Res.getString(233), Res.getString(234), Res.getString(235), Res.getString(236), Res.getString(237), Res.getString(238), Res.getString(239), Res.getString(240), Res.getString(241), Res.getString(242), Res.getString(243), Res.getString(244), Res.getString(245), Res.getString(246), Res.getString(247), Res.getString(248), Res.getString(249), Res.getString(250), Res.getString(251), Res.getString(252), Res.getString(253), Res.getString(254), Res.getString(255), Res.getString(256)}, {"Color.white", "Color.lightGray", "Color.gray", "Color.darkGray", "Color.black", "Color.red", "Color.pink", "Color.orange", "Color.yellow", "Color.green", "Color.magenta", "Color.cyan", "Color.blue", "SystemColor.desktop", "SystemColor.activeCaption", "SystemColor.activeCaptionText", "SystemColor.activeCaptionBorder", "SystemColor.inactiveCaption", "SystemColor.inactiveCaptionText", "SystemColor.inactiveCaptionBorder", "SystemColor.window", "SystemColor.windowBorder", "SystemColor.windowText", "SystemColor.menu", "SystemColor.menuText", "SystemColor.text", "SystemColor.textText", "SystemColor.textHighlight", "SystemColor.textHighlightText", "SystemColor.textInactiveText", "SystemColor.control", "SystemColor.controlText", "SystemColor.controlHighlight", "SystemColor.controlLtHighlight", "SystemColor.controlShadow", "SystemColor.controlDkShadow", "SystemColor.scrollbar", "SystemColor.info", "SystemColor.infoText"}};
        colorValues = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue, SystemColor.desktop, SystemColor.activeCaption, SystemColor.activeCaptionText, SystemColor.activeCaptionBorder, SystemColor.inactiveCaption, SystemColor.inactiveCaptionText, SystemColor.inactiveCaptionBorder, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText, SystemColor.menu, SystemColor.menuText, SystemColor.text, SystemColor.textText, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.control, SystemColor.controlText, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow, SystemColor.scrollbar, SystemColor.info, SystemColor.infoText};
        int n2 = 0;
        try {
            textToValueMap = new HashMap();
            localizedTextToValueMap = new HashMap();
            for (n2 = 0; n2 < colorValues.length; ++n2) {
                if (colorValues[n2] == null) continue;
                localizedTextToValueMap.put(colorNames[0][n2], colorValues[n2]);
                textToValueMap.put(colorNames[1][n2], colorValues[n2]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("color values len ").concat(String.valueOf(n2))).concat(String.valueOf(" "))).concat(String.valueOf(colorValues[n2]))).concat(String.valueOf(colorNames[0][n2]))).concat(String.valueOf(colorNames[1][n2])));
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 40;
        return dimension;
    }

    public static Color textToValue(String string, boolean bl2) {
        return bl2 ? (Color)localizedTextToValueMap.get(string) : (Color)textToValueMap.get(string);
    }

    public static String valueToText(Color color, boolean bl2) {
        int n2;
        for (n2 = 0; n2 < colorValues.length; ++n2) {
            if (color != colorValues[n2]) continue;
            return bl2 ? colorNames[0][n2] : colorNames[1][n2];
        }
        for (n2 = 0; n2 < colorValues.length; ++n2) {
            if (!color.equals(colorValues[n2])) continue;
            return bl2 ? colorNames[0][n2] : colorNames[1][n2];
        }
        return CUSTOM_TAG;
    }

    void fillChoice() {
        for (int i2 = 0; i2 < colorValues.length; ++i2) {
            this.choice.add(colorNames[0][i2]);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choice) {
            Color color = ColorChooserPanel.textToValue(this.choice.getSelectedItem(), true);
            if (color != null) {
                this.changeColor(color, false, false);
            }
        } else {
            this.setHsbMode(itemEvent.getItemSelectable() == this.checkbox[1]);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        try {
            Color color;
            int[] nArray = new int[3];
            boolean bl2 = false;
            int n2 = this.hsbMode ? 100 : 255;
            for (int i2 = 0; i2 < 3; ++i2) {
                nArray[i2] = Integer.parseInt(this.pickers[i2].text.getText());
                if (nArray[i2] >= 0 && nArray[i2] <= n2) continue;
                bl2 = true;
            }
            if (!bl2 && !(color = this.hsbMode ? Color.getHSBColor(Math.min((float)nArray[0] / 100.0f, 0.999999f), (float)nArray[1] / 100.0f, (float)nArray[2] / 100.0f) : new Color(nArray[0], nArray[1], nArray[2])).equals(this.value)) {
                this.changeColor(color, true, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Color color = this.hsbMode ? Color.getHSBColor(Math.min((float)this.pickers[0].scrollbar.getValue() / 100.0f, 0.999999f), (float)this.pickers[1].scrollbar.getValue() / 100.0f, (float)this.pickers[2].scrollbar.getValue() / 100.0f) : new Color(this.pickers[0].scrollbar.getValue(), this.pickers[1].scrollbar.getValue(), this.pickers[2].scrollbar.getValue());
        if (!color.equals(this.value)) {
            this.changeColor(color, false, false);
        }
    }

    public boolean isHsbMode() {
        return this.hsbMode;
    }

    public void setHsbMode(boolean bl2) {
        if (this.hsbMode != bl2) {
            this.hsbMode = bl2;
            int n2 = bl2 ? 100 : 255;
            for (int i2 = 0; i2 < 3; ++i2) {
                this.pickers[i2].label.setText(bl2 ? this.hsbLabels[i2] : this.rgbLabels[i2]);
                this.pickers[i2].scrollbar.setValues(this.comp[i2], 0, 0, n2 + 1);
                this.pickers[i2].sample.setVisible(!bl2);
            }
            this.checkbox[0].setState(!bl2);
            this.checkbox[1].setState(bl2);
            Color color = this.value;
            this.value = null;
            this.changeColor(color);
        }
    }

    protected void changeColor(Color color, boolean bl2, boolean bl3) {
        if (color != null && color.equals(this.value)) {
            return;
        }
        this.value = color;
        if (color == null) {
            return;
        }
        if (!this.hsbMode) {
            this.comp[0] = color.getRed();
            this.comp[1] = color.getGreen();
            this.comp[2] = color.getBlue();
        } else {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.comp[0] = (int)(fArray[0] * (float)100);
            this.comp[1] = (int)(fArray[1] * (float)100);
            this.comp[2] = (int)(fArray[2] * (float)100);
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            int n2;
            if (!bl2) {
                String string = Integer.toString(this.comp[i2]);
                if (this.text[i2] == null || !this.text[i2].equals(string)) {
                    this.text[i2] = string;
                    this.pickers[i2].text.setText(string);
                }
            }
            int n3 = n2 = this.hsbMode ? 100 : 255;
            if (bl3 || this.pickers[i2].scrollbar.getValue() == this.comp[i2]) continue;
            this.pickers[i2].scrollbar.setValues(this.comp[i2], 0, 0, n2 + 1);
        }
        String string = ColorChooserPanel.valueToText(color, true);
        if (string != null) {
            this.choice.select(string);
        }
        if (color != this.sample.getForeground()) {
            this.sample.setForeground(color);
        }
        if (!this.hsbMode) {
            this.pickers[0].sample.setForeground(new Color(255, 255 - this.comp[0], 255 - this.comp[0]));
            this.pickers[1].sample.setForeground(new Color(255 - this.comp[1], 255, 255 - this.comp[1]));
            this.pickers[2].sample.setForeground(new Color(255 - this.comp[2], 255 - this.comp[2], 255));
        }
        this.colorChanged(color);
    }

    protected void changeColor(Color color) {
        this.changeColor(color, false, false);
    }

    protected void colorChanged(Color color) {
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setColorValue(Color color) {
        this.changeColor(color);
        this.changed = false;
    }

    public Color getColorValue() {
        return this.value;
    }

    void jbInit() throws Exception {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 0));
        panel.add(new Label(Res.getString(36)));
        this.fillChoice();
        this.choice.addItemListener(this);
        panel.add(this.choice);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 3));
        for (int i2 = 0; i2 < 3; ++i2) {
            this.pickers[i2] = new AspectPicker();
            this.pickers[i2].text.addKeyListener(this);
            this.pickers[i2].scrollbar.addAdjustmentListener(this);
            panel2.add(this.pickers[i2]);
        }
        Panel panel3 = new Panel();
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.checkbox[0] = new Checkbox("RGB", false, checkboxGroup);
        panel3.add(this.checkbox[0]);
        this.checkbox[1] = new Checkbox("HSB", false, checkboxGroup);
        panel3.add(this.checkbox[1]);
        this.checkbox[0].addItemListener(this);
        this.checkbox[1].addItemListener(this);
        GroupBox groupBox = new GroupBox(Res.getString(35));
        groupBox.setLayout(new BorderLayout());
        groupBox.add((Component)panel2, "Center");
        groupBox.add((Component)panel3, "South");
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)new Label(Res.getString(37)), "North");
        panel4.add((Component)this.sample, "Center");
        PaneConstraints paneConstraints = new PaneConstraints();
        paneConstraints.position = "Left";
        SplitPanel splitPanel = new SplitPanel();
        splitPanel.add((Component)groupBox, paneConstraints);
        paneConstraints.position = "Right";
        paneConstraints.proportion = 0.3f;
        splitPanel.add((Component)panel4, paneConstraints);
        splitPanel.setGap(2);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)panel, "North");
        this.add((Component)splitPanel, "Center");
    }

    public void addNotify() {
        super.addNotify();
        ButtonDialog buttonDialog = this.findButtonDialog();
        if (buttonDialog != null) {
            buttonDialog.setEnterOK(true);
            buttonDialog.setEscapeCancel(true);
        }
    }

    ButtonDialog findButtonDialog() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof ButtonDialog); container = container.getParent()) {
        }
        if (container instanceof ButtonDialog) {
            return (ButtonDialog)container;
        }
        return null;
    }

    public ColorChooserPanel(Color color) {
        this();
        this.value = color;
    }

    public ColorChooserPanel() {
        this.checkbox = new Checkbox[2];
        this.rgbLabels = new String[]{Res.getString(38), Res.getString(39), Res.getString(40)};
        this.hsbLabels = new String[]{Res.getString(41), Res.getString(42), Res.getString(43)};
        this.comp = new int[3];
        this.text = new String[3];
        this.choice = new Choice();
        this.pickers = new AspectPicker[3];
        this.setBevelInner(0);
        this.setMargins(new Insets(0, 5, 5, 5));
        try {
            this.jbInit();
            this.hsbMode = true;
            this.setHsbMode(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.value = Color.white;
    }
}

