/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.BeanPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;

public class GroupBox
extends BeanPanel
implements Serializable {
    protected String textureName;
    protected String label;
    static final LayoutManager defaultLayout = new FlowLayout();

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Font font = graphics.getFont();
        Font font2 = this.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        int n2 = fontMetrics.getAscent();
        int n3 = n2 / 2 + 1;
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return;
        }
        int n4 = n3;
        int n5 = n3;
        int n6 = rectangle.width - n3 - 1;
        int n7 = rectangle.height - n3 - 1;
        graphics.setColor(this.getForeground());
        graphics.drawString(this.label, n4 + n4, n2);
        int n8 = fontMetrics.stringWidth(this.label);
        for (int i2 = 1; i2 >= 0; --i2) {
            graphics.setColor(i2 == 0 ? SystemColor.controlShadow : SystemColor.controlLtHighlight);
            graphics.drawLine(n4 + n4 - 1, n5 + i2, n4 + i2, n5 + i2);
            graphics.drawLine(n4 + i2, n5 + i2, n4 + i2, n7 + i2);
            graphics.drawLine(n4 + i2, n7 + i2, n6 + i2, n7 + i2);
            graphics.drawLine(n6 + i2, n7 + i2, n6 + i2, n5 + i2);
            graphics.drawLine(n6 + i2, n5 + i2, n4 + n4 + n8, n5 + i2);
        }
        graphics.setFont(font);
    }

    public Insets insets() {
        Font font = this.getFont();
        int n2 = 0;
        if (font != null) {
            n2 = ((Component)this).getFontMetrics(font).getHeight();
        }
        return new Insets(n2, n2, n2, n2);
    }

    public String getTextureName() {
        return this.textureName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String string) {
        if (string != null && !string.equals("")) {
            Image image = ImageLoader.load(string, (Component)this);
            if (image == null) throw new IllegalArgumentException(string);
            ImageLoader.waitForImage(this, image);
            this.textureName = string;
            this.setTexture(image);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Font font;
        Dimension dimension = super.getPreferredSize();
        if (this.label != null && !this.label.equals("") && (font = this.getFont()) != null) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
            dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(this.label) + fontMetrics.getHeight() * 2);
        }
        return dimension;
    }

    public GroupBox(String string) {
        super(defaultLayout);
        this.label = string;
        this.focusAware = false;
    }

    public GroupBox() {
        super(defaultLayout);
        this.label = "";
        this.focusAware = false;
    }
}

