/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.view.FieldView;
import com.borland.jbcl.view.WrappedTextItemPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;

public class MessageDialog
extends ButtonDialog {
    protected String message;
    protected Panel messagePanel = new Panel(new BorderLayout());

    public void setFont(Font font) {
        super.setFont(font);
        this.messagePanel.removeAll();
        this.messagePanel.add(this.buildMessageComponent(this.message));
    }

    public Dimension getPreferredSize() {
        return new Dimension(320, 160);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
        this.messagePanel.removeAll();
        this.messagePanel.add(this.buildMessageComponent(string));
    }

    private Component buildMessageComponent(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.stringWidth(string) + 20;
        if (n2 < 320) {
            Label label = new Label(string, 1);
            return label;
        }
        FieldView fieldView = new FieldView();
        fieldView.setFlat(true);
        fieldView.setItemMargins(new Insets(10, 10, 10, 10));
        fieldView.setBackground(SystemColor.control);
        fieldView.setViewManager(new BasicViewManager(new WrappedTextItemPainter()));
        fieldView.getWriteModel().set(string);
        return fieldView;
    }

    public MessageDialog(Frame frame) {
        this(frame, "", "", 1);
    }

    public MessageDialog(Frame frame, String string) {
        this(frame, string, "", 1);
    }

    public MessageDialog(Frame frame, String string, String string2) {
        this(frame, string, string2, 1);
    }

    public MessageDialog(Frame frame, String string, String string2, int n2) {
        super(frame, string, null, n2);
        super.setCenterPanel(this.messagePanel);
        this.message = string2;
        this.messagePanel.add(this.buildMessageComponent(this.message), "Center");
        this.getContentPane().add((Component)this.messagePanel, "Center");
    }
}

